#include "App.h"

CachedData::CachedData() : doing(false), updated(false)
{
	int i = 0;
	for (; i < NUM_CTRLS; ++i)
	{
		ctrls.Add().HSizePosZ(4, 4).TopPosZ(4 + i*(19 + 4), 19).SetData(i + 1);
		ctrls[i].Apply();
		Add(ctrls[i]);
	}

	rateLabel.SetLabel("Rate (ms):");
	rateLabel.LeftPosZ(4).TopPosZ(4 + (i++)*(19 + 4), 19);
	Add(rateLabel);

	const int rateWidth = GetTextSize("1000", Draw::GetStdFont()).cx + rate.GetStdHeight();
	rate.Min(0).NotNull();
	rate.LeftPosZ(4, rateWidth).TopPosZ(4 + (i++)*(19 + 4), 19).SetData(REFRESH_RATE);
	Add(rate);
}

CachedData::~CachedData()
{
	work.ShutdownThreads();
	work.Wait();
}

void CachedData::OnChangeData()
{
	if (!doing && rate.Accept()) doing = true;
	else return;

	rate.SetEditable(false);

	while (doing)
	{
		Sleep(1);
		GuiLock __;
		if (work.IsShutdownThreads()) break;

		for (int i = 0; i < NUM_CTRLS; ++i)
		{
			ctrls[i].SetData(int(~ctrls[i]) % (NUM_CTRLS * 100) + 1);
		}
		
		if (!updated)
		{
			SetTimeCallback(~rate, THISBACK(OnUpdateData));
			updated = true;
		}
	}

	doing = false;
}

void CachedData::OnUpdateData()
{
	GuiLock __;
	if (work.IsShutdownThreads()) return;

	for (int i = 0; i < NUM_CTRLS; ++i)
	{
		ctrls[i].Apply();
	}

	updated = false;
}

void CachedData::LeftDown(Point p, dword keyflags)
{
	if (doing)
	{
		doing = false;
		rate.SetEditable(true);
	}
}

void CachedData::RightDown(Point p, dword keyflags)
{
	work.Run(THISBACK(OnChangeData));
}
