#include "App.h"

NormalData::NormalData() : doing(false)
{
	for (int i = 0; i < NUM_CTRLS; ++i)
	{
		ctrls.Add().HSizePosZ(4, 4).TopPosZ(4 + i*(19 + 4), 19).SetData(i + 1);
		Add(ctrls[i]);
	}
}

NormalData::~NormalData()
{
	work.ShutdownThreads();
	work.Wait();
}

void NormalData::OnChangeData()
{
	if (!doing) doing = true;
	else return;

	while (doing)
	{
		Sleep(1);
		GuiLock __;
		if (work.IsShutdownThreads()) break;

		for (int i = 0; i < NUM_CTRLS; ++i)
		{
			ctrls[i].SetData(int(~ctrls[i]) % (NUM_CTRLS * 100) + 1);
		}
	}

	doing = false;
}

void NormalData::LeftDown(Point p, dword keyflags)
{
	if (doing) doing = false;
}

void NormalData::RightDown(Point p, dword keyflags)
{
	work.Run(THISBACK(OnChangeData));
}
