
#include "CascadeDefs.h"

#include "CascadeView.h"

#ifdef WIN32
#include <Visualization/WNT/Window.hxx>
#include <Visualization/Graphic3d/WNTGraphicDevice.hxx>
#else
#include <GL/glx.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xmu/StdCmap.h>
#include <X11/Xlib.h>
#include <Visualization/Xw/Window.hxx>
#include <Visualization/Graphic3d/GraphicDevice.hxx>
#endif

//#include <Visualization/V3d/View.hxx>

using namespace Upp;

/////////////////////////////////////////////////////////////////////////////////////////
// Constructor
CascadeView::CascadeView(CascadeDocument *Doc)
{
	// Stores the document
	Document = Doc;
	
	View.Nullify();
	
} // END Constructor class CascadeView

/////////////////////////////////////////////////////////////////////////////////////////
// Destructor
CascadeView::~CascadeView()
{
	// Resets document handle
	Document = 0;
	
	// Resets view handle
	View.Nullify();
	
} // END Destructor class CascadeView


/////////////////////////////////////////////////////////////////////////////////////////
// GLInit method
void CascadeView::GLInit()
{
	
	// Creates the view object
	View = Document->getViewer()->CreateView();
	
    Window windowHandle = GetWindow();
    short lo = (short) windowHandle;
    short hi = (short) (windowHandle >> 16);
//    Handle(Xw_Window) hWnd = new Xw_Window(Handle(Graphic3d_GraphicDevice)::DownCast(Document->getViewer()->Device()),(int) hi,(int) lo,Xw_WQ_SAMEQUALITY);
    Handle(Xw_Window) hWnd = new Xw_Window(Document->getGraphicDevice(), windowHandle);
    View->SetWindow( hWnd );
//    if ( !hWnd->IsMapped() )
//        hWnd->Map();
    View->SetBackgroundColor(Quantity_NOC_BLACK);
    View->MustBeResized();

} // END CascadeView::GLInit()


/////////////////////////////////////////////////////////////////////////////////////////
// Paint method
void CascadeView::GLPaint()
{
	if(View.IsNull())
		return;
	View->Redraw();
	
} // END CascadeView::GLPaint()


/////////////////////////////////////////////////////////////////////////////////////////
// Resize method
void CascadeView::GLResize(int w, int h)
{
	if(View.IsNull())
		return;
    View->MustBeResized();
    
} // END CascadeView::GLResize()


/////////////////////////////////////////////////////////////////////////////////////////
// Fit all in view
void CascadeView::FitAll()
{
	if(View.IsNull())
		return;
    View->FitAll();
    View->ZFitAll();
    View->Redraw();

} // END CascadeView::FitAll()
