#ifndef _CascadeDocument_h_
#define _CascadeDocument_h_

#include "CascadeDefs.h"

#ifdef WIN32
#include <Visualization/WNT/Window.hxx>
#include <Visualization/Graphic3d/WNTGraphicDevice.hxx>
#else
#include <Visualization/Xw/Window.hxx>
#include <Visualization/Graphic3d/GraphicDevice.hxx>
#endif

#include <Visualization/V3d/Viewer.hxx>
#include <Visualization/AIS/InteractiveContext.hxx>

class CascadeDocument
{
	private:
		// THE GRAPHIC DEVICE -- STATIC, COMMON TO ALL CascadeDocuments
#ifndef WIN32
		static Handle(Graphic3d_GraphicDevice) GraphicDevice;
#else
		static Handle(Graphic3d_WNTGraphicDevice) GraphicDevice;
#endif

		// THE VIEWER
		Handle(V3d_Viewer) Viewer;
		
		// THE INTERACTIVE CONTEXT
		Handle(AIS_InteractiveContext) Context;
		
		// NUMBER OF CREATED INSTANCES
		static int Instances;
		
	public:
	
		// Constructor
		CascadeDocument();

		// Destructor
		~CascadeDocument();

		// Graphic device property
#ifndef WIN32
		Handle(Graphic3d_GraphicDevice) const &getGraphicDevice() {return GraphicDevice; };
#else
		Handle(Graphic3d_WNTGraphicDevice) const &getGraphicDevice() {return GraphicDevice; };
#endif

		// Viewer property
		Handle(V3d_Viewer) const &getViewer() { return Viewer; };
		
		// Interactive context property
		Handle(AIS_InteractiveContext) const &getContext() { return Context; };


}; // END Class CascadeDocument

#endif
