#ifndef _CascadeView_h_
#define _CascadeView_h_

#include <Visualization/V3d/View.hxx>

#include "CascadeDefs.h"
#include "CascadeDocument.h"

#include <GLCtrl/GLCtrl.h>

using namespace Upp;

class CascadeView : public GLCtrl
{
	private:
	
		// The associated document
		CascadeDocument *Document;
		
		// The view object
		Handle(V3d_View) View;
		
	public:
		typedef CascadeView CLASSNAME;

		// Constructor class CascadeView
		CascadeView(CascadeDocument *Doc);
	
		// Destructor class CascadeView
		~CascadeView();
		
		// Paint method
		virtual void GLPaint();
		
		// Init method
		virtual void GLInit();

		// Called on resize events
		virtual void GLResize( int w, int h );
		
		// Document property
		CascadeDocument const &getDocument(void) { return *Document; };
	
		// Fit all in view
		void FitAll();

}; // END Class CascadeView

#endif
