#include "TestOpenCascade.h"
#include "MakeBottle.h"

#include <Visualization/AIS/Shape.hxx>

#define IMAGEFILE <TestOpenCascade/TestOpenCascade.iml>
#include <Draw/iml_source.h>

GUI_APP_MAIN
{
	//setenv("CSF_GraphicShr", "/usr/lib/libGL", 1);
	setenv("CASROOT", "/opt/OpenCASCADE6.2.0/ros", 1);
	
	TopWindow win;
	win.LeftPos(200, 800);
	win.TopPos(200, 400);

	CascadeDocument Document;

	CascadeView View(&Document);
	StaticRect Rec;
	Rec.Color(Red());
	
	CascadeView View2(&Document);
	Rec.Add(View2.HSizePos(10, 10).VSizePos(10, 10));
	View.Add(Rec.RightPos(20, 300).TopPos(20, 300));
//	View.SetFrame(InsetFrame());

	win.Add(View.HSizePos(10, 10).VSizePos(10, 10));
//	win.Add(View.RightPos(20,400).TopPos(10, 300));
	win.Sizeable().Zoomable();
	
	win.Open();

    TopoDS_Shape aBottle = ::MakeBottle(50,70,30);
    Handle(AIS_Shape) AISBottle=new AIS_Shape(aBottle);
    Document.getContext()->SetMaterial(AISBottle,Graphic3d_NOM_GOLD);
    Document.getContext()->SetDisplayMode(AISBottle,1,Standard_False);
    Document.getContext()->Display(AISBottle, Standard_False);	
    Document.getContext()->SetCurrentObject(AISBottle,Standard_False);
    View.FitAll();
    View2.FitAll();
	
    win.Run();
}

