#ifndef _X11_DHCtrl_h_
#define _X11_DHCtrl_h_

#include <CtrlLib/CtrlLib.h>

NAMESPACE_UPP

class DHCtrl : public Ctrl
{
	private:
	
		// Initialization flag
		bool isInitialized;
		
		// Error flag - signals errors during initialization process
		int isError;
		
		// Mapping flag -- signals if window is mapped or not
		bool isMapped;
		
		// Current size - store to spare unneeded Resize events
		Size CurrentSize;
		
		// Gets the rect inside the top window
		Rect RectInTopWindow(void) const;
		
		// Moves the subwindow according to control position
		void MoveSubWindow(void);
		
		// Maps/unmaps the window
		void MapWindow(bool map);

		// Initializes the view
		bool Init(void);
		
		// Terminates the view
		void Terminate(void);
	
		// State handler	
		virtual void State(int reason);
		
		// Visual info -- for visual selections
		// Used in virtual method SetVisual()
		XVisualInfo* UserVisualInfo;
		
		// Error message... used for debugging purposes
		String ErrorMessage;
		
	protected:
	
		// Ovverriddable method to choose the correct visual
		// in derived classes
		virtual XVisualInfo *CreateVisual(void) {return 0;};
		
		// Overriddable method for attribute setting
		virtual void SetAttributes(unsigned long &ValueMask, XSetWindowAttributes &attr) {};
		
		// Paint function with context
		virtual void Paint(Draw &draw) {};
		
		// Property Visual
		Visual *getVisual(void);
		
		// Property XVisualInfo
		XVisualInfo getVisualInfo(void);
		
		// Those are called just before and after initialization
		// Can be overridden by derivate ctrl
		virtual void BeforeInit(void) {};
		virtual void AfterInit(bool Error) {};

		// Those are called just before and after termination
		// Can be overridden by derivate ctrl
		virtual void BeforeTerminate(void) {};
		virtual void AfterTerminate(void) {};
		
		// Resize event - overridable by derived controls
		virtual void Resize(int w, int h) {};

		// Error setting
		void setError(bool err) { isError = err; }
		
		// Error message setting
		void setErrorMessage(String const &msg) { ErrorMessage = msg; }

	public:
		typedef DHCtrl CLASSNAME;

		// Constructor class X11_DHCtrl
		DHCtrl();
	
		// Destructor class X11_DHCtrl
		~DHCtrl();
		
		// Error checking
		bool getError(void) { return isError; }
		
		// Error message getting
		String const &getErrorMessage(void) { return ErrorMessage; }
		
		// Property Initialized
		bool getInitialized(void) { return isInitialized; }
		
} ; // END Class DHCtrl

END_UPP_NAMESPACE

#endif

