#include "FormatSource.h"

// Constructor Class ASStreamIterator
ASStreamIterator::ASStreamIterator(String const &Src) : ASSourceIterator(), src(Src)
{
	// initializes buffer pointer
	p = 0;
	
} // END Constructor Class ASStreamIterator


bool ASStreamIterator::hasMoreLines() const
{
	return src[p] != 0;
	
} // END ASStreamIterator::hasMoreLines()

string ASStreamIterator::nextLine()
{
	int p2 = p;
	while(src[p2] && src[p2] != '\n')
		p2++;
	String line = src.Mid(p, p2-p);

	if(src[p2])
	   p2++;
	p = p2;

	return line;
	
} // END ASStreamIterator::nextLine()

/////////////////////////////////////////////////////////////////////////////////////////

String FormatSource(String const &Src)
{
	// Instantiate the formatter object
	ASFormatter Formatter;
	
	// Sets up the formatter for C++ formatting
	Formatter.setCStyle();
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Sets up astyle options

	// set the bracket formatting mode.
	// options:
	//    astyle::NONE_MODE     no formatting of brackets.
	//    astyle::ATTACH_MODE   Java, K&R style bracket placement.
	//    astyle::BREAK_MODE    ANSI C/C++ style bracket placement.
	//
	// @param mode         the bracket formatting mode.
	Formatter.setBracketFormatMode(BREAK_MODE);
	
	// set closing header bracket breaking mode
	// options:
	//    true     brackets just before closing headers (e.g. 'else', 'catch')
	//             will be broken, even if standard brackets are attached.
	//    false    closing header brackets will be treated as standard brackets.
	//
	// @param state         the closing header bracket breaking mode.
	Formatter.setBreakClosingHeaderBracketsMode(true);
	
	// set 'else if()' breaking mode
	// options:
	//    true     'else' headers will be broken from their succeeding 'if' headers.
	//    false    'else' headers will be attached to their succeeding 'if' headers.
	//
	// @param state         the 'else if()' breaking mode.
	Formatter.setBreakElseIfsMode(false);
	
	// set operator padding mode.
	// options:
	//    true     statement operators will be padded with spaces around them.
	//    false    statement operators will not be padded.
	//
	// @param state         the padding mode.
	Formatter.setOperatorPaddingMode(true);
	
	// set parenthesis outside padding mode.
	// options:
	//    true     statement parenthesiss will be padded with spaces around them.
	//    false    statement parenthesiss will not be padded.
	//
	// @param state         the padding mode.
	Formatter.setParensOutsidePaddingMode(false);
	
	// set parenthesis inside padding mode.
	// options:
	//    true     statement parenthesis will be padded with spaces around them.
	//    false    statement parenthesis will not be padded.
	//
	// @param state         the padding mode.
	Formatter.setParensInsidePaddingMode(false);
	
	// set parenthesis unpadding mode.
	// options:
	//   true     statement parenthesis will be unpadded with spaces removed around them.
	//   false    statement parenthesis will not be unpadded.
	//
	// @param state         the padding mode.
	Formatter.setParensUnPaddingMode(true);
	
	// set option to break/not break one-line blocks
	//
	// @param state        true = break, false = don't break.
	Formatter.setBreakOneLineBlocksMode(true);
	
	// set option to break/not break lines consisting of multiple statements.
	//
	// @param state        true = break, false = don't break.
	Formatter.setSingleStatementsMode(true);
	
	// set option to convert tabs to spaces.
	//
	// @param state        true = convert, false = don't convert.
	Formatter.setTabSpaceConversionMode(false);
	
	// set option to break unrelated blocks of code with empty lines.
	//
	// @param state        true = convert, false = don't convert.
	Formatter.setBreakBlocksMode(false);
	
	// set option to break closing header blocks of code (such as 'else', 'catch', ...) with empty lines.
	//
	// @param state        true = convert, false = don't convert.
	Formatter.setBreakClosingHeaderBlocksMode(false);

	///////////////////////////////////////////////////////////////////////////////////////////////////////////

	// indent using one tab per indentation
	Formatter.setTabIndentation(4, true);
	
	// indent using a number of spaces per indentation.
	//
	// @param   length     number of spaces per indent.
	// Formatter.setSpaceIndentation(int length)
	
	// set the maximum indentation between two lines in a multi-line statement.
	//
	// @param   max     maximum indentation length.
	// Formatter.setMaxInStatementIndentLength(1000);
	
	// set the minimum indentation between two lines in a multi-line condition.
	//
	// @param   min     minimal indentation length.
	// Formatter.setMinConditionalIndentLength(int min)
	
	// set the state of the bracket indentation option. If true, brackets will
	// be indented one additional indent.
	//
	// @param   state             state of option.
	Formatter.setBracketIndent(false);
	
	// set the state of the block indentation option. If true, entire blocks
	// will be indented one additional indent, similar to the GNU indent style.
	//
	// @param   state             state of option.
	Formatter.setBlockIndent(false);
	
	// set the state of the class indentation option. If true, C++ class
	// definitions will be indented one additional indent.
	//
	// @param   state             state of option.
	Formatter.setClassIndent(false);
	
	// set the state of the switch indentation option. If true, blocks of 'switch'
	// statements will be indented one additional indent.
	//
	// @param   state             state of option.
	Formatter.setSwitchIndent(true);
	
	// set the state of the case indentation option. If true, lines of 'case'
	// statements will be indented one additional indent.
	//
	// @param   state             state of option.
	Formatter.setCaseIndent(false);
	
	// set the state of the namespace indentation option.
	// If true, blocks of 'namespace' statements will be indented one
	// additional indent. Otherwise, NO indentation will be added.
	//
	// @param   state             state of option.
	Formatter.setNamespaceIndent(true);
	
	// set the state of the label indentation option.
	// If true, labels will be indented one indent LESS than the
	// current indentation level.
	// If false, labels will be flushed to the left with NO
	// indent at all.
	//
	// @param   state             state of option.
	Formatter.setLabelIndent(false);
	
	// set the state of the preprocessor indentation option.
	// If true, multiline #define statements will be indented.
	//
	// @param   state             state of option.
	Formatter.setPreprocessorIndent(true);
	
	// set the state of the empty line fill option.
	// If true, empty lines will be filled with the whitespace.
	// of their previous lines.
	// If false, these lines will remain empty.
	//
	// @param   state             state of option.
	Formatter.setEmptyLineFill(false);

	///////////////////////////////////////////////////////////////////////////////////////////////////////////

	// Creates the iterator for the formatter
	ASStreamIterator *streamIterator = new ASStreamIterator(Src);

	// Initializes the formatter to work on selected stream
	Formatter.init(streamIterator);
	
	// Initializes result buffer
	String Dest;

	// Processes all text in source file and put them in output file
	while (Formatter.hasMoreLines())
	{
		String fmt = String(Formatter.nextLine());
		Dest.Cat(fmt);

		// the last line does not get an eol
//		if (Formatter.hasMoreLines())
			Dest.Cat('\n');
	}
	
	delete streamIterator;
	
	return Dest;

	
} // END FormatSource()
