#ifndef _OcasReformatter_PatchIncludes_h_
#define _OcasReformatter_PatchIncludes_h_

#include <Core/Core.h>

using namespace Upp;

////////////////////////////////////////////////////////////////////////////////////////////////
// DIVIDES A CASCADE FILE NAME LIKE xxxxxx_yyyyy.zzz
// INTO 2 PARTS :
//			aaaaa_bbbbb.zzz ==> aaaaa + bbbbb.zzz
// SPECIAL CASES :
//  1)- NO '_' CHARACTER :
//			aaaaa.zzz ==> aaaaa + aaaaa.zzz
//  2)- PARTS BEFORE AND AFTER UNDERSCORE EQUAL :
//			aaaaa_aaaaa.zzz ==> aaaaa + aaaaa_aaaaa.zzz
//  3)- HANDLE NAMES :
//			Handle_aaaaa_bbbbb.zzz ==> aaaaa + Handle_bbbbb.zzz
// ERROR IF NAME DOESN'T CONTAIN NEITHER '_' NOR '.'
bool SplitCascadeName(String const &Name, String &First, String &Second);

/////////////////////////////////////////////////////////////////////////////////////////////////
// PATCHES #include DIRECTIVES INSIDE A FILE
// IT DOES A LIMITATE CHECK ON FILE, SO IT' NOT ERROR-FREE
// IF SOME STRANGE CODE IS USED
String PatchIncludes(const String &Src, const String &CasRoot, const Index<String> &SubPackages, const Array<String> &MainPackages);

#endif
