#ifndef _OcasReformatter_Skips_h_
#define _OcasReformatter_Skips_h_

#include <Core/Core.h>

using namespace Upp;

// skips c++ comment
void SkipCppComment(String const &Src, int &p, String &Dest);

// skips c comment
void SkipCComment(String const &Src, int &p, String &Dest);

// skips spaces and comments
// returns true if StopEol is true and got eol
bool SkipSpacesAndComments(String const &Src, int &p, String &Dest, bool StopEol = false);

// skips to end of line
void SkipToEol(String const &Src, int &p, String &Dest);

// Skips string
void SkipString(String const &Src, int &p, String &Dest);

// Skips single char
void SkipSingleChar(String const &Src, int &p, String &Dest);

// skips code blocks
void SkipBlock(String const &Src, int &p, String &Dest, int level = 1);

#endif
