#include "Skips.h"

// skips c++ comment
void SkipCppComment(String const &Src, int &p, String &Dest)
{
	// Copies till end of line
	char c;
	while( (c = Src[p]) != 0 && c != '\n')
	{
		Dest.Cat(c);
		p++;
	}
	Dest.Cat('\n');
		
	
} // END SkipCppComment()

// skips c comment
void SkipCComment(String const &Src, int &p, String &Dest)
{
	// Copies comment till closing, checking also for nested comments
	Dest.Cat(Src.Mid(p, 2));
	p+=2;
	char c;
	while( (c = Src[p]) != 0)
	{
/* ---- NO NESTED COMMENTS.......		
		// Check for nested comment
		if(c == '/' && Src[p+1] == '*')
			SkipCComment(Src, p, Dest);
		else
*/		
		if(c == '*' && Src[p+1] == '/')
		{
			Dest.Cat(Src.Mid(p, 2));
			p+=2;
			break;
		}
		else
		{
			Dest.Cat(c);
			p++;
		}
	}
	
} // END SkipCComment()

// skips spaces and comments
bool SkipSpacesAndComments(String const &Src, int &p, String &Dest, bool StopEol)
{
	char c;
	while( (c = Src[p]) != 0)
	{
		if(isspace(c))
		{
			Dest.Cat(c);
			p++;
			if(c == '\n' && StopEol)
				return true;
		}
		else if(c == '/' && Src[p+1] == '/')
			SkipCppComment(Src, p, Dest);
		else if(c == '/' && Src[p+1] == '*')
			SkipCComment(Src, p, Dest);
		else
			break;
	}
	
	return false;
	
} // END SkipSpacesAndComments()

// skips to end of line
void SkipToEol(String const &Src, int &p, String &Dest)
{
	char c;
	
	// maybe, copy till end of line the ifndef directive
	while( (c = Src[p]) != 0)
	{ 
		Dest.Cat(c);
		p++;
		if(c == '\n')
			break;
	}
		
} // END SkipToEol()

// Skips string
void SkipString(String const &Src, int &p, String &Dest)
{
	// copies the starting '"'
	Dest.Cat('"');
	p++;
	char c;
	while( (c = Src[p]) != 0)
	{
		// Quote in string
		if(c == '"' && Src[p+1] == '"')
		{
			Dest.Cat('"');
			Dest.Cat('"');
			p+=2;
		}
		else if(c == '\\')
		{
			Dest.Cat('\\');
			Dest.Cat(Src[p+1]);
			p+=2;
		}
		else
		{
			Dest.Cat(c);
			p++;
			if(c == '"')
				break;
		}
	}
	
} // END SkipString()
		
// Skips single char
void SkipSingleChar(String const &Src, int &p, String &Dest)
{
	// copies the starting '''
	Dest.Cat('\'');
	p++;
	char c;
	while( (c = Src[p]) != 0)
	{
		// Single quote in string
		if(c == '\'' && Src[p+1] == '\'')
		{
			Dest.Cat('\'');
			Dest.Cat('\'');
			p+=2;
		}
		// escaped char
		else if(c == '\\')
		{
			Dest.Cat('\\');
			Dest.Cat(Src[p+1]);
			p+=2;
		}
		else
		{
			Dest.Cat(c);
			p++;
			if(c == '\'')
				break;
		}
	}
	
} // END SkipSingleChar()
		
// skips code blocks
void SkipBlock(String const &Src, int &p, String &Dest, int level)
{
	char c;
	Dest.Cat(Src[p]);
	Cerr() << (char)Src[p];
	Dest.Cat(String("/* START ") + AsString(level, 0) + " */");
	level++;
	p++;
	while( Src[p] )
	{
		SkipSpacesAndComments(Src, p, Dest);
		c = Src[p];
		if(!c)
		{
			Cerr() << "\nUNEXPECTED END OF FILE\n";
			break;
		}
		// nested block ?
		if(c == '{')
			SkipBlock(Src, p, Dest, level);
		// is it a string ???
		else if (c == '"')
			// yes, skip it
			SkipString(Src, p, Dest);
		// is it a single character ?
		else if (c == '\'')
			SkipSingleChar(Src, p, Dest);
		else
		{
			Dest.Cat(c);
			Cerr() << c;
			p++;
			if(c == '}')
			{
				level--;
				Dest.Cat(String("/* END ") + AsString(level, 0) + " */");
				return;
			}
		}
	}
	
} // END SkipBlock()
