#include "Skips.h"
#include "AddNamespace.h"

// outputs an error message
extern String __CURFILE__;
void PrintError(String const &Msg)
{
	Cerr() << __CURFILE__ << " : " << Msg << "\n";
	
} // END PrintError()

// gets include path (p must be on '#include' start
String GetIncludePath(String const &Src, int p)
{
	if(Src.Mid(p, 8) != "#include")
		return "";
	
	p+=8;
	while(Src[p] && isspace(Src[p]))
	      p++;
	char delim = Src[p];
	if(delim == '<')
		delim = '>';
	else if(delim != '"')
		return "";
	p++;
	int p2 = p;
	while(Src[p2] && Src[p2] != delim)
		p2++;
	if(!Src[p2])
		return "";
	return Src.Mid(p, p2-p);
	
} // END GetIncludePath

// Starts namespace
void StartNamespace(String &Dest, String const &SpaceName)
{
	Dest.Cat(String("\n#ifdef __cplusplus\n"));
	Dest.Cat(String("#ifdef __OCAS_NAMESPACE_DEFINED\n"));
	Dest.Cat(String("#error \"NESTED NAMESPACES\"\n"));         
	Dest.Cat(String("#else\n"));
	Dest.Cat(String("#define __OCAS_NAMESPACE_DEFINED\n"));
	Dest.Cat(String("#endif\n"));
	Dest.Cat(String("namespace ") + SpaceName + " {\n");
	Dest.Cat(String("#endif\n"));
	
} // END StartNamespace()

// Stops namespace
void StopNamespace(String &Dest, String const &SpaceName)
{
	Dest.Cat(String("\n#ifdef __cplusplus\n"));
	Dest.Cat(String("#undef __OCAS_NAMESPACE_DEFINED\n"));
	Dest.Cat(String("} // END namespace ") + SpaceName + "\n");
	Dest.Cat(String("#endif\n"));
	
} // END StopNamespace()

// skips namespace around include directive
void NamespaceSkipInclude(String const &Src, int &p, String &Dest, String const &SpaceName)
{
	// no namespaces on .pxx
	String Path = GetIncludePath(Src, p);
	String Ext = GetFileExt(Path);
	bool Skip = (Ext == ".pxx");
	
	// yes, must close namespace around it...
	if(!Skip)
		StopNamespace(Dest, SpaceName);
	
	// copy the line...
	SkipToEol(Src, p, Dest);
	
	// reopens namespace
	if(!Skip)
		StartNamespace(Dest, SpaceName);

} // END NamespaceSkipInclude()

// forward declaration
int ReadElseBlock(String const &Src, int &p, String &Dest, int level, String const &SpaceName);

// reads conditional #if block
int ReadIfBlock(String const &Src, int &p, String &Dest, int level, String const &SpaceName)
{
	char c;
	
	// skips condition to eol
	SkipToEol(Src, p, Dest);

	// stores block level of if block
	int iflevel = level;
	int elselevel = level;
	while(Src[p])
	{
		// skips spaces and comments
		SkipSpacesAndComments(Src, p, Dest);
		c = Src[p];
		if(!c)
			break;
		
		// nested if block ?
		if(Src.Mid(p, 3) == "#if")
			iflevel = ReadIfBlock(Src, p, Dest, iflevel, SpaceName);
		// continuous if block
		else if(Src.Mid(p, 7) == "#elseif" || Src.Mid(p, 5) == "#elif")
		{
			elselevel = ReadIfBlock(Src, p, Dest, level, SpaceName);
			if(iflevel != elselevel)
				PrintError("ERROR -- BLOCK LEVEL NESTING DIFFERENT IN #if AND #elseif BLOCKS in ReadIfBlock()");
			return iflevel;
		}
		// else block
		else if(Src.Mid(p, 5) == "#else")
		{
			elselevel = ReadElseBlock(Src, p, Dest, level, SpaceName);
			if(iflevel != elselevel)
				PrintError("ERROR -- BLOCK LEVEL NESTING DIFFERENT IN #if AND #else BLOCKS in ReadIfBlock()");
			return iflevel;
		}
		// endif
		else if(Src.Mid(p, 6) == "#endif")
		{
			SkipToEol(Src, p, Dest);
			return iflevel;
		}
		// is it an include directive ?
		else if(c == '#' && Src.Mid(p, 8) == "#include")
		{
			// namespace only in not block-contaned directives...
			if(!iflevel)
				NamespaceSkipInclude(Src, p, Dest, SpaceName);
			else
				SkipToEol(Src, p, Dest);
		}
		// is it a string ???
		else if (c == '"')
			// yes, skip it
			SkipString(Src, p, Dest);
		// is it a single character ?
		else if (c == '\'')
			SkipSingleChar(Src, p, Dest);
		// none of the above, just copy char
		else
		{
			Dest.Cat(c);
			p++;

			// block
			if(c == '{')
				iflevel++;
			else if(c == '}')
				iflevel--;
		}
	} // while src[p]
	
	PrintError("ERROR -- UNEXPECTED END OF FILE READING #if BLOCK in ReadIfBlock()");
	return iflevel;
	
} // END ReadIfBlock()

// reads conditional #else block
int ReadElseBlock(String const &Src, int &p, String &Dest, int level, String const &SpaceName)
{
	char c;
	
	// skips condition to eol
	SkipToEol(Src, p, Dest);

	// stores block level of if block
	while(Src[p])
	{
		// skips spaces and comments
		SkipSpacesAndComments(Src, p, Dest);
		c = Src[p];
		if(!c)
			break;
		
		// nested if block ?
		if(Src.Mid(p, 3) == "#if")
			level = ReadIfBlock(Src, p, Dest, level, SpaceName);
		// else block
		else if(Src.Mid(p, 5) == "#else")
		{
			PrintError("ERROR - UNEXPECTED #else IN ReadElseBlock()");
			SkipToEol(Src, p, Dest);
			return level;
		}
		// endif
		else if(Src.Mid(p, 6) == "#endif")
		{
			SkipToEol(Src, p, Dest);
			return level;
		}
		// is it an include directive ?
		else if(c == '#' && Src.Mid(p, 8) == "#include")
		{
			// namespace only in not block-contaned directives...
			if(!level)
				NamespaceSkipInclude(Src, p, Dest, SpaceName);
			else
				SkipToEol(Src, p, Dest);
		}
		// is it a string ???
		else if (c == '"')
			// yes, skip it
			SkipString(Src, p, Dest);
		// is it a single character ?
		else if (c == '\'')
			SkipSingleChar(Src, p, Dest);
		// none of the above, just copy char
		else
		{
			Dest.Cat(c);
			p++;

			// block
			if(c == '{')
				level++;
			else if(c == '}')
				level--;
		}
	} // while src[p]
	
	PrintError("ERROR - UNEXPECTED END OF FILE READING #else BLOCK in ReadElseBlock()");
	return level;
	
} // END ReadElseBlock()


// Adds namespaces to files
String AddNamespace(String const &Src, String const &SpaceName)
{
	String Dest;
	int p = 0;
	char c;
	int level = 0;
	
	// starts with namespace
	StartNamespace(Dest, SpaceName);

	// repeat until not end of file
	while(Src[p])
	{
		// skips spaces and comments
		SkipSpacesAndComments(Src, p, Dest);
		c = Src[p];
		if(!c)
			break;
		
		// is it an include directive ?
		if(c == '#' && Src.Mid(p, 8) == "#include")
		{
			// namespace only in not block-contaned directives...
			if(!level)
				NamespaceSkipInclude(Src, p, Dest, SpaceName);
			else
				SkipToEol(Src, p, Dest);
		}
		// #if block ?
		else if(Src.Mid(p, 3) == "#if")
			level = ReadIfBlock(Src, p, Dest, level, SpaceName);
		else if(Src.Mid(p, 5) == "#else")
		{
			PrintError("ERROR - UNEXPECTED #else IN AddNamespace()");
			SkipToEol(Src, p, Dest);
			return Dest;
		}
		else if(Src.Mid(p, 6) == "#endif")
		{
			PrintError("ERROR - UNEXPECTED #endif IN AddNamespace()");
			SkipToEol(Src, p, Dest);
			return Dest;
		}
		// is it a string ???
		else if (c == '"')
			// yes, skip it
			SkipString(Src, p, Dest);
		// is it a single character ?
		else if (c == '\'')
			SkipSingleChar(Src, p, Dest);
		// none of the above, just copy line
		else
		{
			Dest.Cat(c);
			p++;

			// block
			if(c == '{')
				level++;
			else if(c == '}')
				level--;
		}
	}

	// closes namespace at file end
	StopNamespace(Dest, SpaceName);

	Dest.Cat('\0');
	
	// adds a null delimiter as usual
	return Dest;
	
} // END AddNamespace()
