#include "Skips.h"
#include "RemoveGlobalScopes.h"

// Starting from a pointer to a closing parenthesis,
// checks if the construct is of form 'Handle(....)'
// we suppose that NO COMMENT is inside the construct
bool IsHandle(const String &Src, int p)
{
	// Looks for corresponding opening parenthesis
	int PLevel = 1;
	p--;
	while(PLevel && p >= 0)
	{
		char c = Src[p--];
		if(c == ')')
		{
			PLevel++;
			continue;
		}
		else if(c == '(')
		{
			PLevel--;
			continue;
		}
	}
	// if at start of buffer, no Handle()
	if(p <= 0)
		return false;
	
	// Checks for 'Handle'
	if(p >= 5 && Src.Mid(p-5, 6) == "Handle")
		return true;
	
	return false;
	
} // END IsHandle()

// Starting from a pointer to last char of identifier
// preceding scope operator, checks for 'else' or 'return' statements
bool IsElseOrReturnBefore(String const &Src, int p)
{
	int len = 1;
	while(p > 0 && isalnum(Src[p-1]))
	{
		p--;
		len++;
	}
	if(Src.Mid(p, len) == "else" || Src.Mid(p, len) == "return")
		return true;
	return false;
	
} // END IsElseOrReturnBefore()

bool IsTemplateBefore(const String &Src, int p)
{
	// no template if no '>' char
	if(Src[p] != '>')
		return false;
		
	// walks backward, looking for '<' or for start of line
	int p2 = p-1;
	int level = 1;
	char c;
	while(p2 && level && (c = Src[p2]) != '\n')
	{
		if(c == '<')
			level--;
		else if(c == '>')
			level++;
		else if(!isalnum(c) && !isspace(c) && c != ',')
			return false;
		p2--;
	}
		
	// if not found, return false
	if(level)
		return false;
		
	// if arrived here, hopefully is a template... sigh
	return true;

} // END IsTemplateBefore()

// Removes spurious (and unneeded) double colon ::
// on order to prepare for namespace inclusion
String RemoveGlobalScopes(String &Src, String const &SpaceName)
{
	// Initializes dest buffer
	String Dest;
	
	// Initializes buffer pointer
	int p = 0;
	
	// Packing loop
	char c;
	char prevc = 0;
	while(Src[p] != 0)
	{
		// at first, skips spaces and comments
		SkipSpacesAndComments(Src, p, Dest);
		c = Src[p];
		
		// Checks for scope operator
		if(c == ':' && Src[p+1] == ':')
		{
			// found, is at start of file ?
			if(p == 0)
			{
				// yes, must remove it
				p+=2;
				Dest.Cat(" " + SpaceName + "::");
				continue;
			}
			// is it a template function ?
			else if(IsTemplateBefore(Src, p-1))
			{
				// yes, keep the ::
				Dest.Cat("::");
				p+=2;
				continue;
			}
			// has it closing parenthesis before it ?
			else if(Src[p-1] == ')')
			{
				// yes, must check if Handle()
				if(IsHandle(Src, p-1))
				{
					// handle, must keep ::
					Dest.Cat("::");
					p+=2;
					continue;
				}
				else
				{
					// no, must remove it
					p+=2;
					Dest.Cat(" " + SpaceName + "::");
					continue;
				}
			}
			// has it an identifier before ?
			else if(isalnum(Src[p-1]) || Src[p-1] == '_')
			{
				// must check for 'else' or 'return' statements
				if(IsElseOrReturnBefore(Src, p-1))
				{
					// it has, must remove scope operator
					p+=2;
					Dest.Cat(" " + SpaceName + "::");
					continue;
				}
				else
				{
					// no, must keep operator
					p+=2;
					Dest.Cat("::");
					continue;
				}
			}
			// none of the above, just remove scope operator
			p+=2;
			Dest.Cat(" " + SpaceName + "::");
			continue;
		} // END is scope operator

		// check for a string...  better to skip it
		else if(c == '"')
			SkipString(Src, p, Dest);
		
		// check for a single char, better to skip it
		else if(c == '\'')
			SkipSingleChar(Src, p, Dest);
		else
		{
			// other stuffs, just copy char to output
			Dest.Cat(c);
			p++;
		}
	}
	
	// Add \0 terminator to buffer
	// (make simpler buffer handling)
	Dest.Cat(0);
	
	return Dest;
	
} // END RemoveGlobalScopes()
