#include "jsc.h"

COMPILE_ASSERT(!IsInteger<GlobalObject>::value, WTF_IsInteger_GlobalObject_false);
ASSERT_CLASS_FITS_IN_CELL(GlobalObject);

void cleanupGlobalData(JSGlobalData* globalData) {
	JSLock lock(SilenceAssertionsOnly);
	globalData->heap.destroy();
	globalData->deref();
}

void runInteractive(GlobalObject* globalObject) {
	Upp::String line;
	while(true){
		Cout()<<"> ";
		line=ReadStdIn();
		if(line.IsEmpty()) break;
		Completion completion = evaluate(globalObject->globalExec(), globalObject->globalScopeChain(), makeSource(UString(line)));
		if (completion.complType() == Throw)
			Cout()<< "Exception:" << completion.value().toString(globalObject->globalExec()).ascii() <<"\n";
		else
			Cout()<< completion.value().toString(globalObject->globalExec()).UTF8String().data() << "\n";
		globalObject->globalExec()->clearException();
	}
	Cout()<<"\n";
}

CONSOLE_APP_MAIN{
	// Initialize things.
	JSC::initializeThreading();
	JSGlobalData* globalData = JSGlobalData::create(ThreadStackTypeLarge).releaseRef();
	JSLock lock(SilenceAssertionsOnly);
	GlobalObject* globalObject = new(globalData) GlobalObject;
	// run the prompt loop
	runInteractive(globalObject);
	// cleanup afterwards
	cleanupGlobalData(globalData);
}
