#include "jsc.h"

EncodedJSValue JSC_HOST_CALL functionPrint(ExecState* exec) {
	for (unsigned i = 0; i < exec->argumentCount(); ++i)
		Cout()<< (i?" ":"") << exec->argument(i).toString(exec).UTF8String().data();
	Cout()<<"\n";
	return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL functionGC(ExecState* exec) {
	JSLock lock(SilenceAssertionsOnly);
	exec->heap()->collectAllGarbage();
	Cout()<<"Garbage collected\n";
	return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL functionReadline(ExecState* exec) {
	return JSValue::encode(jsString(exec, UString(ReadStdIn())));
}

EncodedJSValue JSC_HOST_CALL functionQuit(ExecState* exec) {
	// Technically, destroying the heap in the middle of JS execution is a no-no,
	// but we want to maintain compatibility with the Mozilla test suite, so
	// we pretend that execution has terminated to avoid ASSERTs, then tear down the heap.
	exec->globalData().dynamicGlobalObject = 0;
	cleanupGlobalData(&exec->globalData());
	exit(EXIT_SUCCESS);
}
