#ifndef _Dispatcher_Dispatcher_h
#define _Dispatcher_Dispatcher_h

#include <Core/Core.h>

using namespace Upp;

template<class T>
class Dispatcher;

template<class T>
class Dispatchable
{
	friend class Dispatcher<T>;
	friend class DispatcherGen;
public:
	virtual 	~Dispatchable();
	void 		UnregisterFromAll();

	virtual void Dispatch(const T & o, unsigned param = 0) = 0; //the callback function
private:
	Vector<Ptr<Dispatcher<T> > > src;
private:
	void 	AddSource(Dispatcher<T> &d);
	void 	RemoveSource(Dispatcher<T> &d);
	int 	FindSource(Dispatcher<T> &d);
};

struct DispatcherBase { virtual ~DispatcherBase() { } };

template<class T>
class Dispatcher : public DispatcherBase, public Pte<Dispatcher<T> >
{
public:
	virtual ~Dispatcher() { }

	void DoDispatch(const T & o, unsigned param = 0) const; //forward to the registered classes

	void Register(Dispatchable<T> & d, unsigned key = 0);
	void Unregister(Dispatchable<T> & d, unsigned key = 0);

	Dispatchable<T> * GetDispatchable(unsigned key);
	int GetCount();
private:
	VectorMap<unsigned, Dispatchable<T> * > tgt;};

//a generic version that accepts any Dispatcher<T>
class GenericDispatcher
{
public:
	virtual ~GenericDispatcher() { }
	
	template<class T>
	void DoDispatch(const T & o, unsigned param = 0) const; //forward to the registered classes

	template<class T>
	void Register(Dispatchable<T> & d, unsigned key = 0);
	template<class T>
	void Unregister(Dispatchable<T> & d, unsigned key = 0);

	template<class T>
	Dispatchable<T> *GetDispatchable(unsigned key);
private:
	template<class T>
	Dispatcher<T> *GetDispatcher();
	template<class T>
	const Dispatcher<T> *GetDispatcher() const;	
private:
	ArrayMap<String, DispatcherBase > dispatchers;	
};
#endif
