#include "Dispatcher.h"

template<class T>
Dispatchable<T>::~Dispatchable()
{
	UnregisterFromAll();
}

template<class T>
void Dispatchable<T>::UnregisterFromAll()
{
	// Pick src vector
	Vector<Ptr<Dispatcher<T> > > list = src;
	// Clear picked state
	src.Clear();
	// Deregister
	for (int i = 0; i < list.GetCount(); i++)
		if (list[i]) 
			list[i]->Unregister(*this);
}

template<class T>
void Dispatchable<T>::AddSource(Dispatcher<T>& d)
{
	if (FindSource(d) < 0)
		src.Add(&d);	
}

template<class T>
void Dispatchable<T>::RemoveSource(Dispatcher<T>& d)
{
	int ix = FindSource(d);
	if (ix < 0) return;
	src.Remove(ix);
}

template<class T>
int Dispatchable<T>::FindSource(Dispatcher<T>& d)
{
	for (int i = 0; i < src.GetCount(); i++)
		if (~src[i] == &d) return i;
	return -1;
}

// the dispatch function

template<class T>
void Dispatcher<T>::DoDispatch(const T & o, unsigned param) const
{
	for(int i = 0; i < tgt.GetCount(); i++)
		tgt[i]->Dispatch(o, param);
}

template<class T>
void Dispatcher<T>::Register(Dispatchable<T>& d, unsigned key)
{
	tgt.FindAdd(key ? key : GetPtrHashValue(&d), &d);
	d.AddSource(*this);
}

template<class T>
void Dispatcher<T>::Unregister(Dispatchable<T>& d, unsigned key)
{
	int ix = tgt.Find(key ? key : GetPtrHashValue(&d));
	if (ix >= 0)
		tgt.Remove(ix);
	d.RemoveSource(*this);
}

template<class T>
Dispatchable<T> * Dispatcher<T>::GetDispatchable(unsigned key)
{
	return tgt.Get(key, NULL);
}

template<class T>
int Dispatcher<T>::GetCount()
{
	return tgt.GetCount();
}

// generic disptchers

template<class T>
void GenericDispatcher::DoDispatch(const T& o, unsigned param) const
{
	const Dispatcher<T> *q = GetDispatcher<T>();
	q->DoDispatch(o, param);
}

template<class T>
void GenericDispatcher::Register(Dispatchable<T> & d, unsigned key)
{
	Dispatcher<T> *q = GetDispatcher<T>();
	if (!q)
		q = &dispatchers.Create<Dispatcher<T> >(typeid(T).name());
	q->Register(d, key);
}

template<class T>
void GenericDispatcher::Unregister(Dispatchable<T>& d, unsigned key)
{
	Dispatcher<T> *q = GetDispatcher<T>();
	if (q) {
		q->Unregister(d);
		if (!q->GetCount())
			dispatchers.RemoveKey(typeid(T).name());
	}
}

template<class T>
Dispatchable<T> * GenericDispatcher::GetDispatchable(unsigned key)
{
	Dispatcher<T> *d = GetDispatcher<T>();
	return d ? dispatchers[ix].Get(key, NULL) : NULL;
}

template<class T>
Dispatcher<T> *GenericDispatcher::GetDispatcher()
{
	int ix = dispatchers.Find(typeid(T).name());
	return (ix >= 0) ? dynamic_cast<Dispatcher<T> *>(&dispatchers[ix]) : NULL;
}

template<class T>
const Dispatcher<T> *GenericDispatcher::GetDispatcher() const
{
	int ix = dispatchers.Find(typeid(T).name());
	return (ix >= 0) ? dynamic_cast<const Dispatcher<T> *>(&dispatchers[ix]) : NULL;
}