#ifndef _jsc_js_h_
#define _jsc_js_h_

#ifdef CORE_H
	#error "jsc.h must be included before Core.h!"
#endif

#define BUILDING_UPP__
#include "config.h"

#include "BytecodeGenerator.h"
#include "Completion.h"
#include "InitializeThreading.h"
#include "JSLock.h"
#include "PrototypeFunction.h"

using namespace JSC;
using namespace WTF;

// We don't want to use LOG and ASSERT from WebKit
#undef LOG
#undef ASSERT

#include <Core/Core.h>
using namespace Upp;

#define JSReturnType EncodedJSValue JSC_HOST_CALL

class JavaScript{
	JSGlobalObject* jsglobalObject;
	JSGlobalData* globalData;
	JSLock lock;
public:
	JavaScript();
	~JavaScript();
	void AddNativeFunction(const char* name,NativeFunction function);
	bool CheckSyntax(const Upp::String& code,Upp::String& result);
	bool Execute(const Upp::String& code,Upp::String& result);
	bool ExecuteFile(const Upp::String& filename,Upp::String& result);
};

#endif
