#include "CtrlLib.h"

NAMESPACE_UPP

SliderCtrl::SliderCtrl()
: m_nMin(0)
, m_nMax(100)
, m_nStep(1)
, m_bRound_step(true)
, m_bJump(false)
, m_nTextLabels( 0 )
, m_bUseCustomThumbs( 0 )
{
	SetValue( 0 );

	Transparent();
	NoWantFocus();
}

bool SliderCtrl::IsVert() const
{
	return GetSize().cx < GetSize().cy;
}

int  SliderCtrl::HoVe(int  x, int  y) const
{
	return IsVert() ? y : x;
}

int& SliderCtrl::HoVeR(int& x, int& y) const
{
	return IsVert() ? y : x;
}

void SliderCtrl::Paint(Draw& w)
{
	Size size = GetSize();
	if(IsVert()) { // Vertical slider
		int half = size.cx >> 1;
		DrawBorder(w, half - 2, 2, 4, size.cy - 4, InsetBorder);
		
		for( int i = m_vValues.GetCount() - 1 ; i >= 0 ; i-- )
		{
			if(!IsNull(m_vValues[i]))
				w.DrawImage((size.cx - ( m_bUseCustomThumbs ? m_vThumbImgs[i].GetSize().cx : CtrlImg::vthumb().GetSize().cx ) ) >> 1,
					SliderToClient(m_vValues[i]),
				    HasCapture() || HasFocus() ? ( m_bUseCustomThumbs ? m_vThumbImgsFocus[i] : CtrlImg::vthumb1() ) : ( m_bUseCustomThumbs ? m_vThumbImgs[i] : CtrlImg::vthumb() ) );
		}
		
		if( m_nTextLabels )
		{
			Size sz = GetTextSize( AsString(m_nMin), StdFont() );
			w.DrawText( size.cx - sz.cx, 0, AsString(m_nMin) );
			sz = GetTextSize( AsString(m_nMax), StdFont() );
			w.DrawText( size.cx - sz.cx, size.cy - sz.cy, AsString(m_nMax) );
			
			if( m_nTextLabels > 2 )
			{
				int		nNumExtra = m_nTextLabels - 2; // sub 2 for the start and end
				float	fValInc = ( m_nMax - m_nMin ) / (nNumExtra + 1.0f);
				float	fPosInc = size.cy / ( nNumExtra + 1.0f );
				
				for( int i = 0 ; i < nNumExtra ; i++ )
				{
					float fVal = ( m_nMin + ( i + 1 ) * fValInc );
					int nVal = (int)( fVal + ( fVal >= 0 ? 0.5f : -0.5f ) );
					int nPos = (int)( 0 + ( i + 1 ) * fPosInc + 0.5f );             
					sz = GetTextSize( AsString( nVal ), StdFont() );
					w.DrawText( size.cx - sz.cx, nPos - (int)( sz.cy / 2.0f + 0.5f ), AsString( nVal ) );
				}
			}
		}
	}
	else { // Horz slider
		int half = size.cy >> 1;
		DrawBorder(w, 2, half - 2, size.cx - 4, 4, InsetBorder);

		for( int i = m_vValues.GetCount() - 1 ; i >= 0 ; i-- )
		{
			if(!IsNull(m_vValues[i]))
				w.DrawImage(SliderToClient(m_vValues[i]), (size.cy - ( m_bUseCustomThumbs ? m_vThumbImgs[i].GetSize().cy : CtrlImg::hthumb().GetSize().cy )) >> 1,
			            HasCapture() || HasFocus() ? (m_bUseCustomThumbs ? m_vThumbImgsFocus[i] : CtrlImg::hthumb1()) : (m_bUseCustomThumbs ? m_vThumbImgs[i] : CtrlImg::hthumb() ));
		}
		
		if( m_nTextLabels )
		{
			w.DrawText( 0, 2, AsString(m_nMin) );
			Size sz = GetTextSize( AsString(m_nMax), StdFont() );
			w.DrawText( size.cx - sz.cx, 2, AsString(m_nMax) );
			
			if( m_nTextLabels > 2 )
			{
				int		nNumExtra = m_nTextLabels - 2; // sub 2 for the start and end
				float	fValInc = ( m_nMax - m_nMin ) / (nNumExtra + 1.0f);
				float	fPosInc = size.cx / ( nNumExtra + 1.0f );
				
				for( int i = 0 ; i < nNumExtra ; i++ )
				{
					float fVal = ( m_nMin + ( i + 1 ) * fValInc );
					int nVal = (int)( fVal + ( fVal >= 0 ? 0.5f : -0.5f ) );
					int nPos = (int)( 0 + ( i + 1 ) * fPosInc + 0.5f );             
					//int nAvg = (int)(( m_nMin + m_nMax ) / 2.0f + 0.5f );
					sz = GetTextSize( AsString( nVal ), StdFont() );
					w.DrawText( nPos - (int)( sz.cx / 2.0f + 0.5f ), 2, AsString( nVal ) );
				}
			}
		}
	}
	if(HasFocus())
		DrawFocus(w, size);
}

bool SliderCtrl::Key(dword key, int repcnt)
{
	if(IsEditable())
		switch(key) {
		case K_LEFT:
		case K_UP:
			Dec();
			return true;
		case K_RIGHT:
		case K_DOWN:
			Inc();
			return true;
		}
	return Ctrl::Key(key, repcnt);
}

void SliderCtrl::LeftDown(Point pos, dword keyflags)
{
	if(!IsEditable())
		return;
	SetWantFocus();
	int thumb = SliderToClient(m_vValues[0]);
	int p = HoVe(pos.x, pos.y);
	if(IsNull(thumb)) {
		SetValue( ClientToSlider(p) );
		WhenSlideFinish();
		UpdateActionRefresh();
	}
	else
	if( ( p >= thumb ) && 
		( p < thumb + HoVe(m_bUseCustomThumbs ? m_vThumbImgs[0].GetSize().cx : CtrlImg::hthumb().GetSize().cx,
			 m_bUseCustomThumbs ? m_vThumbImgs[0].GetSize().cy : CtrlImg::vthumb().GetSize().cy)))
		SetCapture();
	else
	if(m_bJump) {
		m_vValues[0] = ClientToSlider(p);
		WhenSlideFinish();
		UpdateActionRefresh();		
	}
	else {		
		if( ( ( p < thumb) && (m_nMin == Min() ) ) || ( (p > thumb) && ( m_nMin == Max() ) ) )
			Dec();
		else
			Inc();
	}
	Refresh();
}

void SliderCtrl::LeftRepeat(Point p, dword f)
{
	if(!HasCapture())
		LeftDown(p, f);
}

void SliderCtrl::LeftUp(Point pos, dword keyflags)
{
	if (HasCapture())
		WhenSlideFinish();
	Refresh();
}

void SliderCtrl::MouseMove(Point pos, dword keyflags)
{
	if(HasCapture()) {
		int n = ClientToSlider(HoVe(pos.x, pos.y));
		if(n != m_vValues[0]) {
			SetValue( n );
			UpdateActionRefresh();
		}
	}
}

void SliderCtrl::SetData(const Value& v)
{
	int i = v;
	if(!IsNull(i))
		i = minmax(i, Min(), Max() );

	if(i != m_vValues[0]) {
		SetValue( i );
		UpdateRefresh();
	}
}

Value SliderCtrl::GetData( int nIndex /* = 0 */) const
{
	return m_vValues[nIndex];
}

Value  SliderCtrl::GetData() const
{
	return m_vValues[0];
}


SliderCtrl& SliderCtrl::MinMax(int _min, int _max)
{
	if(m_nMin != _min || m_nMax != _max) {
		m_nMin = _min;
		m_nMax = _max;
		if(!IsNull(m_vValues[0])) {
			int v = minmax(m_vValues[0], Min(), Max());
			if(m_vValues[0] != v) {
				SetValue( v );
				Update();
			}
		}
		Refresh();
	}
	return *this;
}

int SliderCtrl::SliderToClient(int v) const
{
	if(IsNull(v))
		return Null;
	v = minmax(v, Min(), Max());

	v = iscale(v - m_nMin, HoVe(GetSize().cx - (m_bUseCustomThumbs ? m_vThumbImgs[0].GetSize().cx : CtrlImg::hthumb().GetSize().cx),
		                         GetSize().cy - (m_bUseCustomThumbs ? m_vThumbImgs[0].GetSize().cy : CtrlImg::vthumb().GetSize().cy)), m_nMax - m_nMin);
	return v;
}

int SliderCtrl::ClientToSlider(int p) const
{
	Size hsz = m_bUseCustomThumbs ? m_vThumbImgs[0].GetSize() : CtrlImg::hthumb().GetSize();
	Size vsz = m_bUseCustomThumbs ? m_vThumbImgs[0].GetSize() : CtrlImg::vthumb().GetSize();
	p -= HoVe(hsz.cx / 2, vsz.cy / 2);
	return minmax(m_nMin + iscale(p, m_nMax - m_nMin,
	                           HoVe(GetSize().cx - hsz.cx, GetSize().cy - vsz.cy)), Min(), Max());
}

void SliderCtrl::Dec()
{
	int n = m_vValues[0];
	if(IsNull(m_vValues[0]))
		n = Max();
	else
	if(n > Min()) {
		if(m_bRound_step && m_nStep > 1)
			n = idivfloor(n - 1, m_nStep) * m_nStep;
		else
			n -= m_nStep;
		if(n < Min())
			n = Min();
	}
	if(n != m_vValues[0]) {
		SetValue( n );
		WhenSlideFinish();
		UpdateActionRefresh();
	}
}

void SliderCtrl::Inc()
{
	int n = m_vValues[0];
	if(IsNull(m_vValues[0]))
		n = Min();
	else
	if(n < Max()) {
		if(m_bRound_step && m_nStep > 1)
			n = idivceil(n + 1, m_nStep) * m_nStep;
		else
			n += m_nStep;
		if(n > Max())
			n = Max();
	}
	if(n != m_vValues[0]) {
		SetValue( n );
		WhenSlideFinish();
		UpdateActionRefresh();
	}
}


void		SliderCtrl::AddOutCtrl( Ctrl* c )
{
	m_vctrlOutput.Add( c );
}


int			SliderCtrl::SetValue( int n, int nIndex /*= 0 */ )
{
	//m_vValues[nIndex] = n;
	if( m_vValues.At(nIndex) != n )
	{
		m_vValues.At(nIndex) = n;
	
		if( m_vctrlOutput.GetCount() > nIndex )
			m_vctrlOutput[nIndex]->SetData( n );
		
		UpdateRefresh();
	}
	
	return n;
}
void SliderCtrl::GotFocus()
{
	Refresh();
}

void SliderCtrl::LostFocus()
{
	Refresh();
}

SliderCtrl::~SliderCtrl() {}

END_UPP_NAMESPACE