class SliderCtrl : public Ctrl {
	
private:
	Vector<int>			m_vValues;
	Vector<Image>		m_vThumbImgs;
	Vector<Image>		m_vThumbImgsFocus;
	
	int           	m_nMin, m_nMax, m_nStep;
	bool          	m_bRound_step;
	bool		  	m_bJump;
	bool			m_bUseCustomThumbs;

	int           SliderToClient(int value) const;
	int           ClientToSlider(int x) const;

	int           HoVe(int  x, int  y) const;
	int&          HoVeR(int& x, int& y) const;
	
	int				Min()	const	{ return Upp::min( m_nMin, m_nMax ); };
	int				Max()	const	{ return Upp::max( m_nMin, m_nMax ); };
	
	Vector<Ctrl*>	m_vctrlOutput;
	
	int				m_nTextLabels;
	int				m_nGradations;
	
protected:

public:
	typedef SliderCtrl CLASSNAME;

	Callback 	  WhenSlideFinish;
	
	SliderCtrl();
	virtual ~SliderCtrl();

	virtual void  Paint(Draw& draw);
	virtual bool  Key(dword key, int repcnt);
	virtual void  LeftDown(Point pos, dword keyflags);
	virtual void  LeftRepeat(Point pos, dword keyflags);
	virtual void  LeftUp(Point pos, dword keyflags);
	virtual void  MouseMove(Point pos, dword keyflags);
	virtual void  GotFocus();
	virtual void  LostFocus();

	virtual void  SetData(const Value& value);
	int				SetValue( int n, int nIndex = 0 );	
	virtual Value GetData( int nIndex = 0 ) const;
	virtual Value  GetData() const;

	void          Inc();
	void          Dec();

	SliderCtrl&   MinMax(int _min, int _max);
	SliderCtrl&   Range(int max)                  { return MinMax(0, max); }
	int           GetMin() const                  { return m_nMin; }
	int           GetMax() const                  { return m_nMax; }

	bool          IsVert() const;
	void		  Jump(bool v = true)			  { m_bJump = v; }

	SliderCtrl&   Step(int _step, bool _r = true) { m_nStep = _step; m_bRound_step = _r; return *this; }
	int           GetStep() const                 { return m_nStep; }
	bool          IsRoundStep() const             { return m_bRound_step; }

	void		AddOutCtrl( Ctrl* c );	
	void		SetTextLabels( int n )				{ m_nTextLabels = n; };
	void		SetGradations( int n )				{ m_nGradations = n; };
	void		UseCustomThumbs( bool b = true )	{ m_bUseCustomThumbs = b; };
	void		SetCustomThumb( Image i, int nIndex = 0 ) { m_vThumbImgs.At( nIndex ) = i; m_vThumbImgsFocus.At( nIndex ) = i; };
};
