
template <class N>
typename Tree<N>::Node *Tree<N>::PreOrderT::Left(typename Tree<N>::Node *root)
{ 
	n = t->First(*root); 
	while (n && t->First(*n)) n = t->First(*n); 
	return n ? n : &t->Root();
}

template <class N>
typename Tree<N>::Node *Tree<N>::PreOrderT::Next()
{ 
	if (!n) n = p; 
	else if (t->First(*n)) n = t->First(*n); 
	else if (t->Next(*n)) n = t->Next(*n);
	else {
		n = t->Parent(*n);
		while (n && !t->Next(*n))
			n = t->Parent(*n);
		n = n ? t->Next(*n) : NULL;
	}
	return n;
}

template <class N>
typename Tree<N>::Node *Tree<N>::PostOrderT::Next()
{ 
	if (!n) n = p;
	if (Left(n)) n = Left(n); 
	else if (t->Next(*n)) { n = t->Next(*n); Next(); } 
	else n = t->Parent(*n);
	return n;	
}

template <class N>
typename Tree<N>::Node &Tree<N>::AddFirst0(typename Tree<N>::Node *p, typename Tree<N>::Node &n)
{
	if (!p->IsLeaf()) return AddBefore0(p->first, n);
	p->first = &n;
	p->last = &n;
	n.parent = p;
	n.next = n.prev = NULL;
	return n;
}

template <class N>
typename Tree<N>::Node &Tree<N>::AddLast0(Node *p, typename Tree<N>::Node &n)
{
	if (!p->IsLeaf()) return AddAfter0(p->last, n);
	p->first = &n;
	p->last = &n;
	n.parent = p;
	n.next = n.prev = NULL;
	return n;
}

template <class N>
typename Tree<N>::Node &Tree<N>::AddBefore0(typename Tree<N>::Node *s, typename Tree<N>::Node &n)
{
	n.prev = s->prev;
	if (n.prev) n.prev->next = &n;
	n.next = s;
	s->prev = &n;
	n.parent = s->parent;
	if (s->parent && s->parent->first == s) s->parent->first = &n;
	return n;
}

template <class N>
typename Tree<N>::Node &Tree<N>::AddAfter0(typename Tree<N>::Node *s, typename Tree<N>::Node &n)
{
	n.next = s->next;
	if (n.next) n.next->prev = &n;
	n.prev = s;
	s->next = &n;
	n.parent = s->parent;
	if (s->parent && s->parent->last == s) s->parent->last = &n;
	return n;
}

template <class N>
void Tree<N>::RemoveDeep(typename Tree<N>::Node& n)
{
	ASSERT(n && n.parent);
	int cnt;
	if (n.first && (cnt = n.ChildCountDeep()) > 5) {
		Vector<int> sorted_list;
		sorted_list.SetCount(cnt);
		PreOrderT t;
		t.Set(this, n);
		cnt = 0;
		while (t.Next())
			sorted_list.Set(cnt++, Find(t.Get()));
		Sort(sorted_list);
		DoRemove(&n);	
		node.Remove(sorted_list);	
	}
	else {
		DoRemove(&n);
		node.Remove(Find(&n));
	}
}

template <class N>
void Tree<N>::Remove(typename Tree<N>::Node& n)
{
	ASSERT(n && n.parent);
	Node *t;
	for (Node *c = n->first; c; c = t) {
		t = c->next;
		AddAfter(n, *c);
	}
	DoRemove(&n);
	node.Remove(Find(&n));
}

template <class N>
void Tree<N>::DoRemove(typename Tree<N>::Node *n)
{
	if (n->next) n->next->prev = n->prev;
	if (n->prev) n->prev->next = n->next;
	if (n->parent->first == n) n->parent->first = n->next;
	if (n->parent->last == n) n->parent->last = n->prev;
}
