template <class N>
class Tree
{
public:	
	class Node
	{
		Node *parent;
		Node *first, *last;
		Node *next, *prev;	
		One<N> data;
		
		template <class T>
		Node& SetData(const T& _data) 				{ data.Create<T>(); *data = _data; return *this; }
		
		friend class Tree;
	public:
		Node() : parent(NULL), first(NULL), last(NULL), next(NULL), prev(NULL) { data.Create<N>(); }	
	
		N&				Data()					{ return *data; }
		bool 			IsLeaf() const			{ return first == NULL; }		
		bool			IsOnlyChild() const		{ return prev == next == NULL; }
		bool			HasOneChild() const		{ return first == last != NULL; }
		int 			ChildCount() const		{ int cnt = 0; for (Node *n = first; n; n = n->next) cnt++; return cnt; }
		int				ChildCountDeep() const  { int cnt = 0; for (Node *n = first; n; n = n->next) cnt += 1 + n->ChildCount(); return cnt; }				
	};
	
	class Traverse : public Moveable<Traverse>
	{
	protected:
		Tree<N> *t;
	public:	
		virtual void  						Reset() 	= 0;
		virtual typename Tree<N>::Node *	Next() 		= 0;
		virtual typename Tree<N>::Node *	Get()		= 0;
		typename Tree<N>::Node *			NextLeaf() 	{ Node *n = Next(); while (n && !n->IsLeaf()) n = Next(); return n; }
	};
private:
	class OutOfOrderT : public Traverse, public Moveable<OutOfOrderT>
	{
		int ix;
		Array<typename Tree<N>::Node> *node;		
	public:
		OutOfOrderT() : node(NULL) 	{ Reset(); } 
		void Set(Tree<N> *tree, Array<typename Tree<N>::Node> *_node, int n = -1) { ASSERT(ix >= -1); t = tree; node = _node; ix = n; }
		
		virtual void 		   			Reset()			{ ix = -1; }
		virtual typename Tree<N>::Node *Get()			{ return (ix >= 0 && ix < node->GetCount()) ? &(*node)[ix] : NULL; }		
		virtual typename Tree<N>::Node *Next()			{ return (ix < node->GetCount()-1) ? &(*node)[++ix] : NULL; } 
	};
	
	class PreOrderT : public Traverse, public Moveable<PreOrderT>
	{
	protected:
		typename Tree<N>::Node  *n, *p;
		typename Tree<N>::Node	*Left(typename Tree<N>::Node *root);
	public:		
		PreOrderT() : p(NULL), n(NULL)										{ } 
		void					 		Set(Tree<N> *tree, typename Tree<N>::Node *start) 	{ t = tree; p = start; }
		void 		  	   				Reset()								{ n = NULL; }		
		virtual typename Tree<N>::Node *Get()								{ return n; }
		virtual typename Tree<N>::Node *Next();	
	};
	
	class PostOrderT : public PreOrderT, public Moveable<PostOrderT>
	{
	public:
		virtual	typename Tree<N>::Node *Next();
	};

	Array<Node>  node;
	Node		 rootnode;
	Node		*root;		 
	One<Traverse> ts;
	
	int		Find(Node *n) const			{ for (int i = 0; i < node.GetCount(); i++) if (&node[i] == n) return i; return -1; }
	void	DoRemove(Node *n);

	Node& 	AddFirst0(Node *p, Node &n);
	Node& 	AddLast0(Node *p, Node &n);
	Node& 	AddBefore0(Node *s, Node &n);
	Node& 	AddAfter0(Node *s, Node &n);	
public:
	Node& 	AddFirst(Node &p)					{ return AddFirst0(&p, node.Add()); }
	Node& 	AddLast(Node &p)					{ return AddLast0(&p, node.Add()); }			
	Node& 	AddBefore(Node &s)					{ return AddBefore0(&s, node.Add()); }
	Node& 	AddAfter(Node &s)					{ return AddAfter0(&s, node.Add()); }	
	template <class T>
	Node& 	AddFirst(Node &p, const T& data)	{ return AddFirst0(&p, node.Add()).SetData(data); }
	template <class T>
	Node& 	AddLast(Node &p, const T& data)		{ return AddLast0(&p, node.Add()).SetData(data); }			
	template <class T>
	Node& 	AddBefore(Node &s, const T& data)	{ return AddBefore0(&s, node.Add()).SetData(data); }
	template <class T>
	Node& 	AddAfter(Node &s, const T& data)	{ return AddAfter0(&s, node.Add()).SetData(data); }
	void 	RemoveDeep(Node &n);
	void 	Remove(Node &n);			

	Node&  	Root() const				{ return *root; }
	Node *	Parent(Node &n) const		{ return n.parent; }
	Node *	Next(Node &n) const			{ return n.next; }
	Node *	Prev(Node &n) const			{ return n.prev; }
	Node *	First(Node &n) const		{ return n.first; }
	Node *	Last(Node &n) const			{ return n.last; }

	Traverse &OutOfOrder() 		 { ts.Clear(); ts.Create<OutOfOrderT>().Set(this, &node, 0); return *ts; }
	Traverse &PreOrder() 		 { return PreOrder(root); }
	Traverse &PostOrder() 		 { return PostOrder(root); }
	Traverse &OutOfOrder(Node *n){ ASSERT(n); ts.Clear(); ts.Create<OutOfOrderT>().Set(this, node, Find(n)); return *ts; }
	Traverse &PreOrder(Node *p)  { ASSERT(p); ts.Clear(); ts.Create<PreOrderT>().Set(this, p); return *ts;  }
	Traverse &PostOrder(Node *p) { ASSERT(p); ts.Clear(); ts.Create<PostOrderT>().Set(this, p); return *ts;  }
	
	Tree<N>()					 { root = &rootnode; }
};

#include "Tree.hpp"