#include "CommPak.h"
#include "Serial.h"



#define IMAGEFILE <CommPak/CommPak.iml>
#include <Draw/iml_source.h>


SerialPort	CommPort;			// My serial object
char		msg[50];			// this is where I build my commands
String		buffer[1024];		// Rx buffer

CommPak::CommPak()
{

	CtrlLayout(*this, "VIVID - COMMPAK");
	NoSizeable().NoZoomable();

	// put some text to the docedit box
	esText <<= "This is the text box which will contain\nthe data received from the serial device\n";

	SetupComms();
	
	btnSetup 			<<= THISBACK(SetupComms);
	btnGetLogs		 	<<= THISBACK(GetLogs);
	btnClearLogs		<<= THISBACK(ClearLogs);
	btnSave				<<=	THISBACK(SaveToFile);


	if (CommPort.ReadDataWaiting())		// if there are characteres to read
	{
		CommPort.ReadData(buffer, sizeof(buffer));
		esText <<= ~esText + buffer;
	}
}

void	CommPak::SaveToFile()
{
	PromptOK("Save to File");
}

void	CommPak::SetupComms()
{
int Cnt;
int Port,Baud;

	WithCommSetup<TopWindow>	CommSetup;
	
	CtrlLayoutOKCancel(CommSetup, "Setup Comms");
	for (Cnt=1;Cnt < 9;Cnt++)
		CommSetup.dlPort.Add(Format("COM%d",Cnt));
	CommSetup.dlBaud.Add("1200");
	CommSetup.dlBaud.Add("2400");
	CommSetup.dlBaud.Add("4800");
	CommSetup.dlBaud.Add("9600");
	CommSetup.dlBaud.Add("19200");
	
	if (CommSetup.Execute() == IDOK)
	{
		Port = CommSetup.dlPort.GetIndex()+1;
		Baud = CommSetup.dlBaud.GetIndex();
		
		PromptOK(Format("COM%d was selected, "
						"BAUD=%d",Port,Baud));

		// if the port is open, close it
		if (CommPort.IsOpened())	CommPort.Close();
		
		// Now open the port at the baud rate
		CommPort.Open(Port,Baud);
	}
}

void	CommPak::GetLogs()
{
	strcpy(msg,"GETLOG\n");
	CommPort.SendData(msg,sizeof(msg));
}

void	CommPak::ClearLogs()
{
	strcpy(msg,"CLRLOG\n");
	CommPort.SendData(msg,sizeof(msg));
}

GUI_APP_MAIN
{
	CommPak().Run();
	
}

