#include "CommPak.h"
#include "Serial.h"



#define IMAGEFILE <CommPak/CommPak.iml>
#include <Draw/iml_source.h>


SerialPort	CommPort;			// My serial object
char		msg[50];			// this is where I build my commands
String		buffer[1024];		// Rx buffer
#define		idRxTimer		1

CommPak::CommPak()
{

	CtrlLayout(*this, "VIVID - COMMPAK");
	NoSizeable().NoZoomable();

	// put some text to the docedit box
	esText <<= "This is the text box which will contain\nthe data received from the serial device\n";

	// SetupComms();
	
	btnSetup 			<<= THISBACK(SetupComms);
	btnGetLogs		 	<<= THISBACK(GetLogs);
	btnClearLogs		<<= THISBACK(ClearLogs);
	btnSave				<<=	THISBACK(SaveToFile);

	if (!CommPort.Open(6,9600))
		PromptOK("Cannot open Port");
	else
	{
		PromptOK("COM open Succeeded");
		SetTimeCallback(-100,THISBACK(CheckRxTmr), idRxTimer);
	}

//	WhenClose = THISBACK(cbClose);
}

void	CommPak::CheckRxTmr()
{
int x;
	if (x = CommPort.ReadDataWaiting())
	{
		// CommPort.ReadData(buffer, x);
		esText <<= Format("%d characters waiting", x);
		
		// How can I append incoming data to the existing esText ??
		// I would get the characters to append in buffer
	}
}

//void	CommPak::cbClose()
//{
//	if (ExistsTimeCallback(idRxTimer))
//			KillTimeCallback(idRxTimer);
//}

void	CommPak::SaveToFile()
{
	PromptOK("Save to File");
}

void	CommPak::SetupComms()
{
int Cnt;
int Port,Baud;

	WithCommSetup<TopWindow>	CommSetup;
	
	CtrlLayoutOKCancel(CommSetup, "Setup Comms");
	for (Cnt=1;Cnt < 9;Cnt++)
		CommSetup.dlPort.Add(Format("COM%d",Cnt));
	CommSetup.dlBaud.Add("1200");
	CommSetup.dlBaud.Add("2400");
	CommSetup.dlBaud.Add("4800");
	CommSetup.dlBaud.Add("9600");
	CommSetup.dlBaud.Add("19200");
	
	CommSetup.dlPort = 5;
	CommSetup.dlBaud = 3;
	
	if (CommSetup.Execute() == IDOK)
	{
		Port = CommSetup.dlPort.GetIndex()+1;
		Baud = CommSetup.dlBaud.GetIndex();
		
		PromptOK(Format("COM%d was selected, "
						"BAUD=%d",Port,Baud));

		// if the port is open, close it
		if (CommPort.IsOpened())	CommPort.Close();
		
		// Now open the port at the baud rate
		if (!CommPort.Open(Port,Baud))
			PromptOK(Format("Cannot open COM%d",Port));
		else
			PromptOK("COM open Succeeded");
		
	}
}

void	CommPak::GetLogs()
{
	CommPort.SendData("GETLOG\n",7);

//	if (CommPort.ReadDataWaiting())
//	{
//		CommPort.ReadData(buffer, sizeof(buffer));
//		esText <<= ~esText + buffer;
//	}
}

void	CommPak::ClearLogs()
{
	CommPort.SendData("CLRLOG\n",7);
}

GUI_APP_MAIN
{
	CommPak().Run();
	
}

