#ifndef _CsvComparator_CsvComparator_h
#define _CsvComparator_CsvComparator_h

#include <CtrlLib/CtrlLib.h>
#include "GridCtrl/GridCtrl.h"
#include "Docking/Docking.h"
#include "TabBar/TabBar.h"
#include "Scatter/Scatter.h"

using namespace Upp;

#define LAYOUTFILE <CsvComparator/CsvComparator.lay>
#include <CtrlCore/lay.h>



#define TRACE_INFO(TXT)  { String _msg; _msg << TXT; PromptOK( _msg ); LOG(_msg); }
#define TRACE_ERROR(TXT)  { TRACE_INFO( "## ERROR> " << TXT ) }

typedef	Vector<Vector<String> > TokenContainer; // [row][col]



class StaticTextCtrl : public StaticText
{
	public:
		StaticTextCtrl()
		{
		}
		
		virtual ~StaticTextCtrl() {}
		
		virtual void SetData(const Value& data)
		{
			if (IsTypeRaw<String>(data))
			{
				const String &pv = ValueTo<String>(data);
				StaticText::SetText(pv);
			}
		}
};

class ErrorCtrlsContainer
{
	private:
		typedef Vector<StaticTextCtrl*> VectorErrorCtrls;
		VectorErrorCtrls  errorCtrls;

	public:
		ErrorCtrlsContainer() {}
		~ErrorCtrlsContainer()
		{
			VectorErrorCtrls::Iterator iter = errorCtrls.Begin();
			
			while ( iter != errorCtrls.End() )
			{
				delete (*iter);
				++iter;
			}
		}
		
		StaticTextCtrl& GetNewCtrl()
		{
			StaticTextCtrl* res = new StaticTextCtrl;
			errorCtrls.Add(res);
			return *res;
		}
};



class CsvComparator : public WithCsvComparatorLayout<TopWindow>
{
public:
	typedef CsvComparator CLASSNAME;
	CsvComparator(String csvRef, String CompareCode, String csvResult);
	~CsvComparator();

	typedef enum {
		FILE_DOES_NOT_EXIST   = -1,
		NBR_ROWS_IS_DIFF      = -2,
		NBR_COL_IS_DIFF       = -3,
		FILE_MISFORMED        = -4,
		FAILED_TO_EXECUTE     = -5,
		BAD_PARAMETER_NUMBER  = -6,
		FILES_ARE_IDENTICAL   =  0,
		FILES_ARE_DIFERENT    =  1
	} ErrorCodes;
	
	ErrorCodes doCompare();
private:
	String code;
	String refFile;
	String resultFile;

	int nbRows;
	int nbColumns;
	
	const char*** refTokensArray;
	const char*** resultTokensArray;
	
	TokenContainer refTokens;
	TokenContainer resultTokens;
};

#endif

