
typedef enum {
	CDTE_NOT_PROCESSED= 0,
	CDTE_UINT         = 1,
	CDTE_INT          = 2,
	CDTE_FLOAT        = 3,
	CDTE_STRING       = 4,
	CDTE_BOOL         = 5
} ColumnDataTypeEnum;


typedef unsigned long long CDT_UINT;
typedef signed long long   CDT_INT;
typedef double             CDT_FLOAT;
typedef const char*        CDT_STRING;
typedef bool               CDT_BOOL;


void getParsingSeparators(char* lineSeparator,  char* columnSeparator)
{
	*lineSeparator='\n';
	*columnSeparator='	';
}



ColumnDataTypeEnum getDataType(int colNbr)
{
	ColumnDataTypeEnum res = CDTE_NOT_PROCESSED;
	switch(colNbr)
	{
		case 0: res = CDTE_INT; break;
		case 1: res = CDTE_STRING; break;
		case 2: res = CDTE_FLOAT; break;
		case 3: res = CDTE_FLOAT; break;
		case 7: res = CDTE_STRING; break;
	}
	return res;
}



bool testCol_0(int curRow, CDT_INT* col, CDT_INT* refCol, const char*** reslutStrings, const char*** refStrings)
{
	return (col[curRow] == refCol[curRow]);
}

bool testCol_1(int curRow, CDT_STRING* col, CDT_STRING* refCol, const char*** reslutStrings, const char*** refStrings)
{
	return ( strcmp(col[curRow], refCol[curRow]) == 0 );
}

bool testCol_2(int curRow, CDT_FLOAT* col, CDT_FLOAT* refCol, const char*** reslutStrings, const char*** refStrings)
{
	return ((col[curRow] == refCol[curRow]) || (col[curRow] == -refCol[curRow]));
}

bool testCol_3(int curRow, CDT_FLOAT* col, CDT_FLOAT* refCol, const char*** reslutStrings, const char*** refStrings)
{
	return (col[curRow] == refCol[curRow]);
}

bool testCol_7(int curRow, CDT_STRING* col, CDT_STRING* refCol, const char*** reslutStrings, const char*** refStrings)
{
	return ( strcmp(col[curRow], refCol[curRow]) == 0 );
}


