#include "CommPak.h"
#include "Serial.h"


SerialPort	CommPort;			// My serial object
#define		idRxTimer			1

CommPak::CommPak()
{

	CtrlLayout(*this, "Jerson's - CommPak");
	NoSizeable().NoZoomable();
	Icon(MyImg::vmlogo());

	// SetupComms();
	
	btnSetup 			<<= THISBACK(SetupComms);
	btnGetLogs		 	<<= THISBACK(GetLogs);
	btnClearLogs		<<= THISBACK(ClearLogs);
	btnSave				<<=	THISBACK(SaveToFile);

	if (!CommPort.Open(6,9600))
		Exclamation("Cannot open COM6");
	else
		SetTimeCallback(-100,THISBACK(CheckRxTmr), idRxTimer);

}

void	CommPak::CheckRxTmr()
{
	// mrjt helped with this section 
	char buff[65]; // Last byte reserved for 0 terminator
	
	while (CommPort.ReadDataWaiting() ) {
		int bytes_read = CommPort.ReadData(buff, 64);
		buff[bytes_read] = 0;
		esText.Insert(esText.GetLength(), buff);		
	}
}

void	CommPak::SaveToFile()
{
	String filename;
	
	FileSel fs;
	fs.ExecuteSaveAs("Name the file");
	filename = fs;
	
	if (!SaveFile(filename, ~esText))
		Exclamation("Could not save data to the file" + filename);
}

void	CommPak::SetupComms()
{
int Cnt;
int Port,Baud[]={1200,2400,4800,9600,19200};

	WithCommSetup<TopWindow>	CommSetup;

	// stop the timer before changing anything
	if (ExistsTimeCallback(idRxTimer))
	{
		KillTimeCallback(idRxTimer);
	}

	// if the port is open, close it
	if (CommPort.IsOpened())	CommPort.Close();
	
	CtrlLayoutOKCancel(CommSetup, "Setup Comms");
	for (Cnt=1;Cnt < 9; Cnt++)
		CommSetup.dlPort.Add(Format("COM%d",Cnt));
	for (Cnt=0; Cnt < sizeof(Baud)/sizeof(int); Cnt++)
		CommSetup.dlBaud.Add(Format("%d",Baud[Cnt]));
	
	CommSetup.dlPort = "COM6";	// choose to display COM6
	CommSetup.dlBaud= "9600";	// and 9600 baud
	
	if (CommSetup.Execute() == IDOK)
	{
		Port = CommSetup.dlPort.GetIndex()+1;

		// Now open the port at the baud rate
		if (!CommPort.Open(Port,Baud[CommSetup.dlBaud.GetIndex()]))
			Exclamation(Format("Cannot open COM%d",Port));
		else
		{
			SetTimeCallback(-100,THISBACK(CheckRxTmr), idRxTimer);
		}
	}
}

void	CommPak::GetLogs()
{
	CommPort.SendData("GETLOG\n",7);
//	SetTimeCallback(250,THISBACK(CheckRxTmr), idRxTimer);
}

void	CommPak::ClearLogs()
{	
	CommPort.SendData("CLRLOG\n",7);	
//	SetTimeCallback(250,THISBACK(CheckRxTmr), idRxTimer);
}
	
GUI_APP_MAIN
{
	CommPak().Run();
}

