topic "Инструкция по классам поточного (де)шифрования AES";
[2 $$0,0#00000000000000000000000000000000:Default]
[l288;i1120;a17;O9;~~~.1408;2 $$1,0#10431211400427159095818037425705:param]
[a83;*R6 $$2,5#31310162474203024125188417583966:caption]
[H4;b83;*4 $$3,5#07864147445237544204411237157677:title]
[i288;O9;C2 $$4,6#40027414424643823182269349404212:item]
[b42;a42;2 $$5,5#45413000475342174754091244180557:text]
[l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc]
[l321;C@5;1 $$7,7#20902679421464641399138805415013:code]
[b2503;2 $$8,0#65142375456100023862071332075487:separator]
[*@(0.0.255)2 $$9,0#83433469410354161042741608181528:base]
[C2 $$10,0#37138531426314131251341829483380:class]
[l288;a17;*1 $$11,11#70004532496200323422659154056402:requirement]
[i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam]
[b167;C2 $$13,13#92430459443460461911108080531343:item1]
[i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2]
[*@2$(0.128.128)2 $$15,15#34511555403152284025741354420178:NewsDate]
[l321;*C$7;2 $$16,16#03451589433145915344929335295360:result]
[l321;b83;a83;*C$7;2 $$17,17#07531550463529505371228428965313:result`-line]
[l160;*C+117 $$18,5#88603949442205825958800053222425:package`-title]
[2 $$19,0#53580023442335529039900623488521:gap]
[C2 $$20,20#70211524482531209251820423858195:class`-nested]
[b50;2 $$21,21#03324558446220344731010354752573:Par]
[{_}%EN-US 
[s2; Инструкция по классам поточного 
(де)шифрования AES`*Stream&]
[s5; &]
[s0; Данные классы решают следующие проблемы:&]
[s0;i150;O2; Максимальная защита персональных 
данных при хранении их байтового 
представления в общем доступе&]
[s0;i150;O2; Возможность работы с большими 
объёмами информации (свыше 4 ГБ) без 
использования значительных системных 
ресурсов (за счёт поточного шифрования) 
и без потери криптографической стойкости&]
[s0; &]
[s0; Для этого, в качестве основы была 
выбрана библиотека OpenSSL и алгоритм 
шифрования AES (Rijndael) как принятый стандарт 
в обеспечении безопасности информации.&]
[s0; Для работы с классами, [* требуется 
установленная библиотека OpenSSL]. Как 
установить OpenSSL, смотрите [^topic`:`/`/AESStream`/src`/Installing`_OpenSSL`$en`-us^ з
десь].&]
[s0; &]
[s2; &]
[s2; 1. Шифрование&]
[s5;i150;O1; Создать киптографически стойкий 
ключ шифрования. Длина ключа может 
быть 16, 24 или 32 байта (128/192/256 бит соответствен
но). Ключи другого размера не поддерживаются
. Пожалуйста, обратите внимание на 
то, что в некоторых странах определённые 
размеры ключей запрещены законодательно.&]
[s7; String key(AESRandomString(32));&]
[s5;l192; [*_ NB] Не используйте в качестве ключа 
пароли пользователя `- это сводит 
на нет всю систему защиты.&]
[s5; &]
[s5;i150;O1; Создать объект класса AESEncoderStream 
для того, чтобы начать шифрование 
с его помощью. &]
[s7; AESEncoderStream aesEncoder(dataSize, key);&]
[s5;l192; В качестве аргументов идут длина 
шифруемых данных (в байтах) и созданный 
выше ключ.&]
[s5;l192; [*_ NB] При шифровании в поточном режиме, 
первым аргументом должна быть передана 
[* полная ]длина всего потока данных.&]
[s5;l192; Созданный объект предназначен 
для шифрования одного потока байтов. 
Для шифрования других данных следует 
создавать другие объекты AESEncoderStream.&]
[s5;l192; Если данный тип ключа не поддерживается 
библиотекой, конструктор выбросит 
исключение типа (const char `*) с описанием 
ошибки.&]
[s5; &]
[s5;i150;O1; Сам процесс шифрования данных:&]
[s7; String someData;&]
[s7; //...&]
[s7; aesEncoder << someData;&]
[s5;l192; После чего получаем из объекта 
выходные зашифрованные данные:&]
[s7; sOut << aesEncoder;&]
[s5; &]
[s5;i150;O1; Поточный режим. Класс AESEncoderStream 
будет `"принимать`" в себя данные любыми 
кусками до тех пор, пока их размер 
не станет равным длине, указанной 
в его конструкторе. При каждом вызове 
`"приёма`" данных в AESEncoderStream, происходит 
его шифрование, при этом оперативная 
память, требуемая для шифрования, 
сравнима с размером шифруемого куска 
данных. Таким образом, можно шифровать 
объёмы данных практически любого 
размера (ограничение сверху `- размер 
64`-битного беззнакового целого) без 
существенных затрат оперативной 
памяти.&]
[s7; for (...) &]
[s7; `{&]
[s7; -|/`*...`*/&]
[s7; -|aesEncoder << someDataXXX;&]
[s7; -|/`*...`*/&]
[s7; -|sOut << aesEncoder;&]
[s7; `}&]
[s0;l224; На выходе из объекта будет только 
та часть зашифрованных данных, которая 
была сформирована из необработанных 
входных данных. При этом следует учитывать, 
что процесс шифрования идёт по кускам. 
Поэтому в некоторых итерациях цикла 
поточного шифрования на выходе может 
быть пустая строка. Когда на вход 
поступит достаточное количество 
дополнительных входных байтов, объект 
выдаст необходимое число байтов на 
выходе.&]
[s0;l224; Структура выходных данных никак 
не зависит от размера и числа кусков 
при шифровании в поточном режиме. 
При дешифровании выходных данных 
с правильным ключом, всегда будут 
получаться оригинальные данные.&]
[s0; &]
[s0; &]
[s2; 2. Дешифрование&]
[s5; За дешифрование отвечает класс AESDecoderStream. 
Для дешифрования требуется знать 
ключ. Если задать неправильный ключ 
и начать дешифрование, будет выброшено 
исключение типа (const char `*), содержащее 
строку с указанием ошибки. Исключение 
того же типа может быть выброшено 
в конструкторе объекта при появлении 
тех или иных проблем.&]
[s5; &]
[s5;i150;O1; Создание объекта для дешифрования. 
Объект AESDecoderStream дешифрует один поток 
данных и поддерживает поточный режим. 
Для дешифровки других потоков данных 
следует создавать другой объект.&]
[s7; AESDecoderStream aesDecoder(key);&]
[s5; &]
[s5;i150;O1; Дешифрование.&]
[s7; aesDecoder << encryptedData;&]
[s5;l160; После чего на выходе получаем 
дешифрованные данные:&]
[s7; sDecoded << aesDecoder;&]
[s5;l160; Также следует помнить о возможности 
выброса исключения в случае если 
установленный ключ не совпадает с 
ключом, с которым данные были зашифрованы.&]
[s5; &]
[s5;i150;O1; Поточный режим. Организуется 
аналогично поточному режиму класса 
AESEncoderStream. Шифрованные байты точно 
также можно подавать частями и забирать 
частями дешифрованные данные. С учётом 
размера блоков шифрования, в некоторых 
итерациях цикла поточного дешифрования, 
на выходе может быть пустая строка 
до тех пор, пока число дополнительных 
байтов на входе не достигнет необходимой 
величины.&]
[s5;l160; Сложнее дело обстоит с определением 
оригинального размера шифрованных 
данных при дешифовании в поточном 
режиме. Дело в том, что определить 
его возможно только на определённом 
этапе дешифрования (когда на вход 
объекта поступит достаточное число 
байтов для дешифрования заголовка). 
До тех пор, пока заголовок не дешифрован, 
функция`-член возвращает нулевой 
размер исходных данных. Поэтому, проверять 
размер оригинальных данных следует 
с оторожностью:&]
[s7; if (!aesDecoder.GetSize())&]
[s7; `{ //still no answer...&]
[s7; `}&]
[s7; else&]
[s7; `{//now I know original data size!&]
[s7; `}&]
[s5;l160; В момент дешифрования заголовка 
также может быть выброшено исключение, 
если оригинальный ключ не совпал 
с установленным. При этом, сам оригинальный 
ключ не хранится в шифрованных данных 
ни в каком виде.&]
[s5;l160; Цикл поточного дешифрования похож 
на цикл поточного шифрования:&]
[s7; for (...) &]
[s7; `{&]
[s7; -|/`*...`*/&]
[s7; -|aesDecoder << encryptedDataXXX;&]
[s7; -|/`*...`*/&]
[s7; -|sOut << aesDecoder;&]
[s7; `}&]
[s5; &]
[s5; &]
[s2; 3. Примечания&]
[s5;i150;O2; Размер шифрованных данных больше 
размера исходных данных на 32 байта, 
с учётом выравнивания по 16`-ти байтовой 
границе. Например, если длина исходных 
данных равна 170, длина шифрованных 
данных будет равна:&]
[s5;l192; 170 с округлением по 16`-ти байтовой 
границе `= 176&]
[s5;l192; `+&]
[s5;l192; 32 байта&]
[s5;l192; `= 208 байтов.&]
[s0; &]
[s0; &]
[s2; 4. Известные проблемы&]
[s0;i150;O0; Пакет не компилируется под Win32 
при помощи gcc/MSYS.&]
[s0; &]
[s0; Если у Вас есть любая информация 
по их решению, либо о других проблемах 
в пакете, пожалуйста, пишите [^http`:`/`/www`.ultimatepp`.org`/forum`/index`.php`?t`=msg`&th`=4640`&start`=0`&^ с
юда].&]
[s0; ]