#include "Grapher.h"

#define IMAGECLASS IconsImg
#define IMAGEFILE <Grapher/icons.iml>
#include <Draw/iml_source.h>

void DefaultLoader(const String& filename,PlotData& pd){
	pd.SetTitle(GetFileName(filename));
}

PlotTree::PlotTree(PlotCtrl& plot):plot(plot),pulled(true){
	CtrlLayout(*this);

	tree.MultiSelect(true);
	tree.WhenCursor 	= THISBACK(OnTreeCursor);
	tree.WhenBar 		= THISBACK(OnTreeContext);
	tree.WhenDropInsert = THISBACK(OnTreeDrop);
	tree.WhenDrag 		= THISBACK(OnTreeDrag);
	tree.WhenSel		= THISBACK(OnTreeSel);
	tree.WhenOpen		= THISBACK(OnTreeOpen);
	tree.WhenClose		= THISBACK(OnTreeClose);
	
	newgraph 	<<= THISBACK(OnNewGraph);
	deletegraph	<<= THISBACK(OnDeleteGraph);
	newdata		<<= THISBACK(OnOpenData);
	deletedata	<<= THISBACK(OnCloseData);
	expand		<<= THISBACK1(OpenAll,true);
	collapse	<<= THISBACK1(OpenAll,false);
	
	newgraph.SetImage(IconsImg::AddGraph());
	deletegraph.SetImage(IconsImg::RemoveGraph());
	newdata.SetImage(CtrlImg::open());
	deletedata.SetImage(CtrlImg::remove());
	expand.SetImage(CtrlImg::Plus());
	collapse.SetImage(CtrlImg::Minus());
	
	OnTreeSel();
	Loader=DefaultLoader;
	tree.MultiSelect(false).NoRoot();
}
void PlotTree::OnOpenData(){
	static FileSelector fs;
	fs.Multi(true);
	if(fs.ExecuteOpen()){
		Pull();
		int id=tree.GetSel()[0];
		int p=tree.GetParent(id);
		p=(p==0)?id:p;
		String graph=tree.GetValue(p);
		for(int i=0;i<fs.GetCount();i++){
			NewData(fs[i],graph);
		}
		RefreshTree();
		tree.Open(p);
		tree.SetCursor(id);
	}
}
void PlotTree::OnCloseData(){
	Vector<int> sel=tree.GetSel();
	if(sel.GetCount()==0)
		sel.Add(tree.GetCursor());
	for(int i=sel.GetCount()-1;i>=0;i--){
		if(sel[i]<=0)return;
		Pull();
		int p=tree.GetParent(sel[i]);
		ASSERT(p>0);
		CloseData(tree.GetValue(p),tree.GetNode(sel[i]).key);
		Push(last);
	}
}
void PlotTree::CloseData(const String& graph,int ii){
	int i=graphs.Find(graph);
	if(i>=0){
		graphs[i].data.Remove(ii);
		RefreshTree();
	}
}
void PlotTree::OnNewGraph(){
	String s("Graph "+IntStr(graphs.GetCount()+1));
	if (EditText(s, "New Graph", "Graph name:"))
		if(graphs.Find(s)<0){
			Pull();
			NewGraph(s);
			Push(s);
		}else{
			PromptOK(Format("Graph '%s' already exists.",s));
			OnNewGraph();
		}
}
void PlotTree::OnDeleteGraph(){
	Vector<int> sel=tree.GetSel();
	if(sel.GetCount()==0)
		sel.Add(tree.GetCursor());
	Pull();
	for(int i=sel.GetCount()-1;i>=0;i--){
		if(sel[i]<=0) continue;
		int p=tree.GetParent(sel[i]);
		String graph=tree.GetValue((p==0)?sel[i]:p);
		if (!PromptOKCancel(Format("Remove graph '%s' and all associated data?", graph))) return;
		DeleteGraph(graph);
	}
	if(graphs.GetCount()>0) SetGraph(0);
	OnTreeSel();
}
void PlotTree::NewGraph(const String& graph,bool refresh){
	graphs.FindAdd(graph);
	if(refresh){RefreshTree();}
}
PlotData& PlotTree::NewData(const String& filename,const String& graph){
	Pull();
	int i=graphs.Find(graph);
	if(i<0){
		NewGraph(graph,false);
		i=graphs.FindLast(graph);
	}
	graphs[i].data.Add(-1);
	Loader(filename,graphs[i].data.Top());
	RefreshTree();
	Push(i);
	return graphs[i].data.Top();
}
PlotData& PlotTree::NewData(const PlotData& data,const String& graph){
	Pull();
	int i=graphs.Find(graph);
	if(i<0){
		NewGraph(graph,false);
		i=graphs.FindLast(graph);
	}
	graphs[i].data.Add(-1,data);
	RefreshTree();
	Push(i);
	return graphs[i].data.Top();
}
void PlotTree::DeleteGraph(const String& graph){
	int i=graphs.Find(graph);
	if(i>=0){
		graphs.Remove(i);
		RefreshTree();
	}
}
void PlotTree::UpdateTree(){
	RefreshTree();
	Push(last);
}
void PlotTree::OnRename(){
	Vector<int> sel=tree.GetSel();
	if(sel.GetCount()==0)
		sel.Add(tree.GetCursor());
	if(sel.GetCount()!=1) return;
	int id=sel[0];
	int p = tree.GetParent(id);
	String oldname=tree.GetValue(id);
	String newname(oldname);
	if (EditText(newname, (p==0)?"Rename graph":"Rename data", "New name:")) {
		if(newname==oldname) return;
		if(p==0){
			if(graphs.Find(newname)<0){
				graphs.SetKey(graphs.Find(oldname),newname);
				RefreshTree();
			}else{
				PromptOK(Format("Graph '%s' already exists.",newname));
				OnRename();
			}
		}else{
			int i=tree.GetNode(id).key;
			String graph=tree.GetValue(p);
			graphs.FindPtr(graph)->data[i].SetTitle(newname);
			if(!pulled&&graph==last){
				plot.data[i].SetTitle(newname);
			}
			RefreshTree();
		}
	}
}
void PlotTree::OnProperties(){
	Vector<int> sel=tree.GetSel();
	if(sel.GetCount()==0)
		sel.Add(tree.GetCursor());
	if(sel.GetCount()!=1) return;
	int id=sel[0];
	int p = tree.GetParent(id);
	ASSERT(!pulled);
	PlotStyleDlg psd(plot,p==0?0:(int)tree.GetNode(id).key);
	psd.Run();
	SetGraph(last);
	RefreshTree();
}
void PlotTree::RefreshTree(){
	TreeCtrl::Node n;
	tree.Clear();
	tree.MultiSelect();
	for(int i = 0; i < graphs.GetCount(); i++){
		n.Set("_graphnode_",graphs.GetKey(i)).SetImage(IconsImg::Graph());
		int pid=tree.Add(0,n);
		graphs[i].id=pid;
		for(int j = 0; j < graphs[i].data.GetCount(); j++){
			n.Set(j,graphs[i].data[j].GetTitle()).SetImage(graphs[i].data[j].GetIcon());
			graphs[i].data.SetKey(j,tree.Add(pid,n));
		}
		tree.Open(pid,graphs[i].open);
	}
}
void PlotTree::OnTreeContext(Bar& bar){
	int id = tree.GetCursor();
	if (id > 0) {
		int p = tree.GetParent(id);
		String name=tree.GetValue(id);
		bar.Add("Add data to "+(p==0?name:tree.GetValue(p).ToString()),CtrlImg::open(),THISBACK(OnOpenData));
		if(p!=0){
			bar.Add("Properties ...",Image(),THISBACK(OnProperties));
			bar.Add("Rename "+name,Image(),THISBACK(OnRename));
			bar.Add("Close "+name,CtrlImg::remove(),THISBACK(OnCloseData));
		}
		bar.Separator();
		bar.Add("Add new graph",IconsImg::AddGraph(),THISBACK(OnNewGraph));
		if(p==0){
			bar.Add("Rename "+name,Image(),THISBACK(OnRename));
			bar.Add("Remove "+name,IconsImg::RemoveGraph(), THISBACK(OnDeleteGraph));
		}
		bar.Separator();
		bar.Add("Expand all",CtrlImg::Plus(),THISBACK1(OpenAll,true));
		bar.Add("Collapse all",CtrlImg::Minus(),THISBACK1(OpenAll,false));
	}else{
		bar.Add("Add new graph",IconsImg::AddGraph(),THISBACK(OnNewGraph));
	}
}
void PlotTree::OnTreeSel() {
	static bool isgraph;
	Vector<int> sel=tree.GetSel();
	int c=sel.GetCount();
	if(c==0){
		int id=tree.GetCursor();
		if(id>0){sel.Add(id); c=1;}
	}else{
		if(c>1){
			for(int i=0;i<c;i++){
				if(isgraph!=(tree.GetNode(sel[i]).key==Value("_graphnode_")))
					tree.SelectOne(sel[i],false);
			}
			c=tree.GetSelectCount();
		}else{
			isgraph=tree.GetNode(sel[0]).key==Value("_graphnode_");
		}
	}
	newdata.Enable(c==1);
	deletedata.Enable(c>0&&!isgraph);
	deletegraph.Enable(c>0&&isgraph);
}
void PlotTree::OnTreeDrag(){
	Vector<int> sel=tree.GetSel();
	if(sel.GetCount()==0)
		sel.Add(tree.GetCursor());
	if(sel.GetCount()>0){
		Pull();
		const char* type=(tree.GetParent(sel[0])==0)?"graph":"data";
		tree.DoDragAndDrop(InternalClip(tree, type), tree.GetDragSample());
		Push(last);
	}
}
void PlotTree::OnTreeDrop(int parent, int ii, PasteClip& d){
	if(parent!=0&&IsAvailableInternal<TreeCtrl>(d, "data")
	            &&tree.GetNode(parent).key==Value("_graphnode_")){
		d.Accept();
		if (d.IsPaste()){
			int id=graphs.Find(tree.GetValue(parent));
			ASSERT(id>=0);
			graphs[id].open=true;
			Vector<int> sel=tree.GetSel();
			Vector<PlotData> tmp;
			for(int i=sel.GetCount()-1;i>=0;i--){
				int ix =graphs.Find(tree.GetValue(tree.GetParent(sel[i])));
				int iix=tree.GetNode(sel[i]).key;
				ASSERT(ix>=0);
				tmp.Add()=PlotData(graphs[ix].data[iix],1);
				if(d.GetAction()&DND_MOVE){
					if(ix!=id) graphs[ix].data.Remove(iix);
					else tree.Set(sel[i],-3,"");
				}
			}
			for(int i=0;i<tmp.GetCount();i++){
				graphs[id].data.Insert(ii,-1,tmp[i]);
				tree.Insert(parent,ii);
			}
			if(d.GetAction()&DND_MOVE){
				for(int i=graphs[id].data.GetCount()-1;i>=0;i--){
					if(tree.GetNode(tree.GetChild(parent,i)).key==-3){
						graphs[id].data.Remove(i);
					}
				}
			}
			RefreshTree();
			SetGraph(id);
			return;
		}
	}
	if(parent==0&&IsAvailableInternal<TreeCtrl>(d, "graph")) {
		d.Accept();
		if (d.IsPaste()){
			Vector<int> sel=tree.GetSel();
			VectorMap<String,graph> tmp;
			for(int i=sel.GetCount()-1;i>=0;i--){
				int id=graphs.Find(tree.GetValue(sel[i]));
				tmp.Add(graphs.GetKey(id))=graph(graphs[id],1);
				graphs[id].id=-2;
			}
			DUMPM(graphs);
			DUMPM(tmp);
			for(int i=0;i<tmp.GetCount();i++){
				graphs.Insert(ii,tmp.GetKey(i),tmp[i]);
			}
			
			DUMPM(graphs);
			if(d.GetAction()&DND_MOVE){
				for(int i=graphs.GetCount()-1;i>=0;i--){
					if(graphs[i].id==-2) graphs.Remove(i);
				}
			}
			DUMPM(graphs);
			RefreshTree();
			OnTreeSel();
			return;
		}
	}
}
void PlotTree::OpenAll(bool open){
	tree.OpenDeep(0,open);
}
void PlotTree::SetGraph(const String& graph){
	int i=graphs.Find(graph);
	if(i>=0) SetGraph(i);
}
void PlotTree::Pull(){
	if(!pulled){
		LOG("pull");
		int ix=graphs.Find(last);
		if(ix>=0){
			graphs[ix].rect=plot.GetLimits();
			graphs[ix].data.Clear();
			for(int j=0;j<plot.data.GetCount();j++){
				graphs[ix].data.Add(-1)<<=plot.data[j];
			}
		}
		pulled=true;
	}
}
void PlotTree::Push(const String& graph){
	int i=graphs.Find(graph);
	if(i>=0) Push(i);
}
void PlotTree::Push(int i){
	pulled=false;
	plot.data<<=graphs[i].data.GetValues();
	last=graphs.GetKey(i);
	if(!graphs[i].rect.IsNullInstance()){plot.SetLimits(graphs[i].rect);}
	else{plot.ZoomAll();}
	plot.SetModify();
	plot.Refresh();
}
void PlotTree::SetGraph(int i){
	Pull();
	Push(i);
}
void PlotTree::OnTreeOpen(int id){
	int i=graphs.Find(tree.GetValue(id));
	if(i>=0) graphs[i].open=true;
}
void PlotTree::OnTreeClose(int id){
	int i=graphs.Find(tree.GetValue(id));
	if(i>=0) graphs[i].open=false;
}
void PlotTree::OnTreeCursor(){
	int id=tree.GetCursor();
	if(tree.GetSelectCount()<=1&&id>0){
		int p=tree.GetParent(id);
		p=p==0?id:p;
		String graph=tree.GetValue(p);
		if(graph!=last) SetGraph(graph);
	}
}
