#ifndef _Grapher_Grapher_h
#define _Grapher_Grapher_h

#include <PlotCtrl/PlotCtrl.h>

using namespace Upp;

#define LAYOUTFILE <Grapher/Grapher.lay>
#include <CtrlCore/lay.h>

#define IMAGECLASS IconsImg
#define IMAGEFILE <Grapher/icons.iml>
#include <Draw/iml_header.h>


class PlotTree : public WithPlotTreeLayout<ParentCtrl>{
public:
	typedef PlotTree CLASSNAME;
	PlotTree(PlotCtrl& plot);

	void (*Loader)(const String&,PlotData&);

	void NewGraph(const String& graph,bool refresh=true);
	PlotData& NewData(const String& filename,const String& graph);
	PlotData& NewData(const PlotData& data,const String& graph);
	void DeleteGraph(const String& graph);
	void CloseData(const String& graph,int ii);
	void SetGraph(const String& graph);
	void SetGraph(int i);
	void UpdateTree();

private:
	String last;
	bool pulled;
	PlotCtrl& plot;
	
	struct graph:public Moveable<graph>,public DeepCopyOption<graph>{
		bool open;
		int id;
		Rectf rect;
		VectorMap<int,PlotData> data;
		graph():open(true),rect(Null){}
		graph(const graph& g,int):open(g.open),id(g.id),data(g.data,1),rect(g.rect){}
		String ToString()const{return Format("%i,%s",id,open?"T":"F");};
	};
	VectorMap<String,graph> graphs;
	
	void RefreshTree();
	void Pull();
	void Push(int i);
	void Push(const String& graph);

	void OnTreeContext(Bar& bar);
	void OnTreeCursor();
	void OnTreeDrag();
	void OnTreeDrop(int parent, int ii, PasteClip& d);
	void OnTreeSel();
	void OnTreeOpen(int id);
	void OnTreeClose(int id);
	
	void OnNewGraph();
	void OnDeleteGraph();
	void OnOpenData();
	void OnCloseData();
	void OnRename();
	void OnProperties();
	
	void OpenAll(bool open);
};

#endif

