#include "Grapher.h"

using namespace Upp;

#define GRAPHER_DEMO

void MyLoader(const String& filename,PlotData& pd){
	FileIn f(filename);
	String ln;
	while(!f.IsEof()&&!f.IsError()){
		ln=f.GetLine();
		if(TrimBoth(ln).StartsWith("#")) continue;
		double x=ScanDouble(ln);
		double y=ScanDouble(ln.Mid(ln.Find(" ")));
		if(IsNull(x)||IsNull(y)) continue;
		pd.Add(Pointf(x,y));
	}
	f.Close();
	pd.SetTitle(GetFileName(filename));
}

class Grapher:public TopWindow{
public:
	typedef Grapher CLASSNAME;
	PlotTree tree;
	Vector<PlotData> list;
	PlotCtrl plot;
	Splitter split;
	Grapher():tree(plot){
		split.Set(tree,plot);
		split.SetPos(2500);
		Add(split.SizePos());
		Sizeable().Zoomable().Icon(IconsImg::Graph());
		tree.Loader=MyLoader;
		tree.NewGraph("Graph 1");
		tree.tree.SelectOne(1);
		plot.ZoomAll();
	}
	bool Key(dword keys, int count){
		if (keys==K_CTRL_A){
			plot.ZoomAll(true);
			return true;
		}
		return false;
	}
	#ifdef GRAPHER_DEMO
	void Demo(){
		tree.NewData(GetHomeDirFile("test1.tmp"),"Graph 1")
		        .SetDash("2.5 4").SetThickness(2.5);
		tree.UpdateTree();
		tree.NewData(GetHomeDirFile("test2.tmp"),"Graph 2")
		        .SetSymbol("Cross",Size(9,9),Black()).SetColor(LtRed());
		tree.UpdateTree();
		tree.NewData(GetHomeDirFile("test3.tmp"),"Graph 1")
		        .SetSymbol("XCross",Size(9,9),LtBlue()).SetColor(Green()).SetThickness(2);
		tree.UpdateTree();
		plot.ZoomAll();
	}
	#endif
};

GUI_APP_MAIN{
	Grapher g;
	
	#ifdef GRAPHER_DEMO
		FileOut f;
		f.Open(GetHomeDirFile("test1.tmp"));
		for(double d=0;d<M_2PI;d+=0.01){
			f.PutLine(Format("%f %f",d,sin(d)));
		}
		f.Close();
		f.Open(GetHomeDirFile("test2.tmp"));
		for(double d=0;d<M_2PI;d+=0.1){
			f.PutLine(Format("%f %f",sin(d),cos(d)));
		}
		f.PutLine(Format("%f %f",0,1));
		f.Close();
		f.Open(GetHomeDirFile("test3.tmp"));
		for(double d=0;d<M_2PI;d+=0.01){
			f.PutLine(Format("%f %f",d,sin(2*d)));
		}
		f.Close();
		g.Demo();
	#endif
	
	g.Run();
	
	#ifdef GRAPHER_DEMO
		DeleteFile(GetHomeDirFile("test1.tmp"));
		DeleteFile(GetHomeDirFile("test2.tmp"));
		DeleteFile(GetHomeDirFile("test3.tmp"));
	#endif
}