#include "TimberHtml.h"

TimberHtml::TimberHtml()
{
	CtrlLayout(*this, "TimberStruct HTML website generator");
	Sizeable().Zoomable();
	
	cancelBtn.Cancel() <<= THISBACK(quitCb);
	runBtn <<= THISBACK(runCb);
	
	configFile = ConfigFile();
	LoadFromFile(*this, configFile);
	
	optionsCb();
	
	genPDFOption <<= THISBACK(optionsCb);
	genHTMLOption <<= THISBACK(optionsCb);
	
	runBtn <<= THISBACK(runCb);
	cancelBtn <<= THISBACK(quitCb);
}

TimberHtml::~TimberHtml()
{
	StoreToFile(*this, configFile);
}

void TimberHtml::Serialize(Stream &s)
{
	s % genPDFOption % genHTMLOption % packageFolder % pdfFolder % htmlFolder;
}

void TimberHtml::runCb(void)
{
	buildHtml(packageFolder, htmlFolder);
}

void TimberHtml::quitCb(void)
{
	Break();
}

void TimberHtml::optionsCb(void)
{
	pdfFolder.Enable(genPDFOption);
	htmlFolder.Enable(genHTMLOption);
}

// gathers links from topic and builds translation map
VectorMap<String, String>GatherLinks(String const &tpp)
{
	VectorMap <String, String> res;
	int pos = 0;
	String magic = "^topic`:`/`/";
	while( (pos = tpp.Find(magic, pos)) >= 0)
	{
		int start = pos + magic.GetCount();
		int end = tpp.Find("^ ", start);
		if(end < 0)
			break;
		String link = tpp.Mid(start, end - start);
		int i;
		while( (i = link.Find('`')) >= 0)
			link.Remove(i);
		if(link != "")
			res.Add("topic://" + link, GetFileName(link) + ".html");
		pos = end + 1;
	}
	return res;
}

// builds html file and stores images on destpath
bool TimberHtml::buildHtml(String packagePath, String destPath)
{
	if(!packagePath.EndsWith("/")) packagePath += "/";
	if(!destPath.EndsWith("/")) destPath += "/";
	if(!DirectoryExists(packagePath))
	{
		PromptOK("[*= Path&" + packagePath + "&not found]");
		return false;
	}
	String tppPath = packagePath + "app.tpp/";
	if(!DirectoryExists(tppPath))
	{
		PromptOK("[*= Package has not application topics]");
		return false;
	}
	if(!DirectoryExists(destPath))
	{
		PromptOK("[*= Path&" + destPath + "&not found]");
		return false;
	}
	
	// gathers all topic files
	FindFile ff;
	Vector<String> tppFiles;
	ff.Search(tppPath + "*.tpp");
	while(ff)
	{
		if(ff.IsFile())
			tppFiles.Add(tppPath + ff.GetName());
		ff.Next();
	}
	if(!tppFiles.GetCount())
	{
		PromptOK("[* No .tpp files found!!!]");
		return false;
	}
	
	String footer =
		"</body>\n"
		"</html>\n";
	
	Index<String> css;
	for(int iFile = 0; iFile < tppFiles.GetCount(); iFile++)
	{
		String tppFile = tppFiles[iFile];
		String name = GetFileTitle(tppFile);
			
		String tpp = LoadFile(tppFile);
		
		// gathers links and translates them
		VectorMap<String, String> links = GatherLinks(tpp);

		// scans tpp file, if starts with topic title
		// strips it and stores as page title
		String title;
		if(tpp.StartsWith("topic"))
		{
			int s = tpp.Find("\"", 5);
			if(s >= 0)
			{
				s++;
				int e = tpp.Find("\";", s);
				if(e >= 0)
				{
					title = tpp.Mid(s, e-s);
					tpp = tpp.Mid(e + 2);
				}
			}
		}
		String header = 
			"<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n"
			"<html>\n"
			"<head>\n"
			"<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">\n"
			"<META NAME=\"Generator\" CONTENT=\"TimberHtml\">\n"	
			"<title>" + title + "</title>\n"
			"<link rel=\"stylesheet\" href=\"style.css\">\n"
			"</head>\n"
			"\n"
			"<body>\n";
		String html = header + EncodeHtml(ParseQTF(tpp), css, links, destPath, name) + footer;
		SaveFile(destPath + name + ".html", html);
	}
	
	String cssString = AsCss(css);
	SaveFile(destPath + "style.css", cssString);
	return true;
}
