#ifndef _HelpViewer_HelpViewer_h
#define _HelpViewer_HelpViewer_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define IMAGEFILE <HelpViewer/HelpViewer.iml>
#include <Draw/iml_header.h>

class HelpViewer : public TopWindow
{
	private:
		Splitter splitter;
		RichTextView tocPane, contentsPane;
		
		// reacts on TOC link selection
		void tocLinkCb(String const &link);
		
		ToolBar        toolbar;
		Zoom           zoom;
	
		struct Pos : Moveable<Pos>
		{
			String link;
			int    scy;
		};
		
		Vector<Pos>    back;
		Vector<Pos>    forward;
		String         topic;
		String         label;
		String         current_link;

	public:
		typedef HelpViewer CLASSNAME;
		
		HelpViewer();
		
		// loads TOC contents
		bool LoadTOC(String const &toc);
		
		// loads help topic
		bool LoadTopic(String const &topic);
};

#endif

