#include "HelpViewer.h"

#define IMAGEFILE <HelpViewer/HelpViewer.iml>
#include <Draw/iml_source.h>

HelpViewer::HelpViewer()
{
	// setups splitter and its contents
	Add(splitter);
	splitter.Horz(tocPane, contentsPane).SetPos(2500);
	tocPane.AutoHideSb();
	tocPane.SetZoom(Zoom(1,1));
	contentsPane.AutoHideSb();
	contentsPane.SetZoom(Zoom(1,1));
	
	// setup TOC link callback
	tocPane.WhenLink << THISBACK(tocLinkCb);
	contentsPane.WhenLink << THISBACK(tocLinkCb);
	
	zoom.m = 160;
	zoom.d = 1000;
	
	Sizeable().Zoomable();
}

void HelpViewer::tocLinkCb(String const &link)
{
	Topic t = GetTopic(link);
	if(!IsNull(t.text))
	{
		label = t.label;
		topic = t.link;
		Title(FromUtf8(t.title));
		RichText txt = ParseQTF(t.text);
		contentsPane.Pick(txt, zoom);
		contentsPane.GotoLabel(label, true);
		current_link = link;
	}
}

// loads TOC and header contents
bool HelpViewer::LoadTOC(String const &toc)
{
	Topic t = GetTopic(toc);
	if(!IsNull(t.text))
	{
		label = t.label;
		topic = t.link;
		Title(FromUtf8(t.title));
		RichText txt = ParseQTF(t.text);
		tocPane.Pick(txt, zoom);
		tocPane.GotoLabel(label, true);
		
		// scans for the first link in text and sets it in
		// contents pane
		String link;
		int i = t.text.Find("[^topic");
		if(i >= 0)
		{
			i += 2;
			int j = t.text.Find("^ ", i+5);
			if(j >= 0)
			{
				String lnk = t.text.Mid(i, j-i);
				for(int k = 0; k < lnk.GetCount(); k++)
					if(lnk[k] != '`')
						link += lnk[k];
			}
		}
		if(link != "")
			tocLinkCb(link);
				
		return true;
	}
	return false;
}

// loads help topic
bool HelpViewer::LoadTopic(String const &topic)
{
}
