#include <CtrlLib/CtrlLib.h>

#define IMAGEFILE <guitest/layers.iml>
#define IMAGECLASS LayersImg
#include <Draw/iml.h>

using namespace Upp;

struct Layer:public Moveable<Layer>{
	String name;
	bool lock,visible,active;
	Color color;
	Layer(){};
	Layer(String n,bool a,bool l,bool v, Color c):name(n),active(a),lock(l),visible(v),color(c){};
	String ToString()const{
		String s;
		s<<name<<": "<<active<<", "<<lock<<", "<<visible<<", "<<color;
		return s;
	}
};
struct MyLock:public ButtonOption{
	MyLock(){
		SetImage(LayersImg::unlocked(),LayersImg::locked());
	}
};
struct MyBulb:public ButtonOption{
	MyBulb(){
		SetImage(LayersImg::bulb_off(),LayersImg::bulb_on());
	}
};
struct App : TopWindow {
	ArrayCtrl a;
	Vector<Layer> l;
	
	typedef App CLASSNAME;
	
	App() {
		int cy=Draw::GetStdFontCy() + 4;
		Add(a.SizePos());
		a.NoGrid();
		a.SetLineCy(cy);
		a.AddColumn("Layer");
		a.AddColumn("Visible").Ctrls<MyBulb>();
		a.AddColumn("Locked").Ctrls<MyLock>();
		a.AddColumn("Color").Ctrls<ColorPusher>();
		for(int i = 0; i < 10; i++) {
			l.Add(Layer("Layer "+IntStr(i),false,Random()%3==0,Random()%2==0,LtBlue()));
		}
		DUMPC(l);
		SyncArray();
		Sizeable();
		a.Inserting().Appending().NoAppendLine().Duplicating().Removing().RowName("layer");
		a.WhenCtrlsAction=THISBACK(SyncLayers);
		a.WhenSel=THISBACK(SyncActive);
		a.WhenBar<<THISBACK(OnBar);
		a.WhenArrayAction=THISBACK(SyncLayers);
	}
	~App(){DUMPC(l);}
	void OnBar(Bar& bar){
		bar.Add("Rename...",THISBACK(Rename));
	}
	void Rename(){
		int i=a.GetCursor();
		String str=a.Get(i,0);
		if(EditText(str,"Rename layer","New name: ")){
			l[i].name=str;
			SyncArray();
		}
	}
	void SyncArray(){
		a.Clear();
		a.ColumnWidths("10 1 1 1");
		for(int i = 0; i < l.GetCount(); i++) {
			a.Add(l[i].name,l[i].lock,l[i].visible,l[i].color);
			if(l[i].active) a.SetCursor(i);
		}
	}
	void SyncLayers(){
		l.Clear();
		for(int i = 0; i < a.GetCount(); i++) {
			l.Add(Layer(a.Get(i,0),i==a.GetCursor(),a.Get(i,1),a.Get(i,2),a.Get(i,3)));
		}
	}
	void SyncActive(){
		for(int i = 0; i < l.GetCount(); i++) {
			l[i].active=(i==a.GetCursor());
		}
	}
};

GUI_APP_MAIN
{
	App().Run();
}
