#include "NIDAQmx.h"

/**********************************************************************/
#define DAQmxErrChk(functionCall) if( DAQmxFailed(error=(functionCall)) ) goto Error; else

void	Ni_ReadAllDI0(int32* DI)
{
   int32      error=0;
   TaskHandle   taskHandle=0;
   uInt32      data;
   char      errBuff[2048]={'\0'};
   int32      read;

   /*********************************************/
   // DAQmx Configure Code
   /*********************************************/
   DAQmxErrChk (DAQmxCreateTask("",&taskHandle));
   DAQmxErrChk (DAQmxCreateDIChan(taskHandle,"Dev1/port0","",DAQmx_Val_ChanForAllLines));

   /*********************************************/
   // DAQmx Start Code
   /*********************************************/
   DAQmxErrChk (DAQmxStartTask(taskHandle));

   /*********************************************/
   // DAQmx Read Code
   /*********************************************/
   DAQmxErrChk (DAQmxReadDigitalU32(taskHandle,1,10.0,DAQmx_Val_GroupByChannel,&data,1,&read,NULL));

	// assign the read inputs to *DI
	*DI = data;
	return;

Error:
   if( DAQmxFailed(error) )
      DAQmxGetExtendedErrorInfo(errBuff,2048);
   if( taskHandle!=0 ) {
      /*********************************************/
      // DAQmx Stop Code
      /*********************************************/
      DAQmxStopTask(taskHandle);
      DAQmxClearTask(taskHandle);
   }
//   if( DAQmxFailed(error) )      text.SetText(Format("DAQmx Error: %s\n",errBuff));
}
