#ifndef _JFControlsDemo_main_h_
#define _JFControlsDemo_main_h_

#include <JFControls/JFControls.h>

#define LAYOUTFILE <JFControlsDemo/JFControlsDemo.lay>
#include <CtrlCore/lay.h>

class JFControlsDemo : public WithlayDemo<TopWindow> {

public:
	typedef JFControlsDemo CLASSNAME;
	JFControlsDemo();

private:
	void	Upd_sliInd1(),
			Upd_sliInd2(),
			Upd_sliswInd1(),
			Upd_sliswInd2();
	
	void	NiCheck();
};

// Global Settings go here
struct T_RGOP {
	Value 	Range,
			Gain,
			Offset,
			Precision;
	
	void	Serialize(Stream& stream)
	{
		stream 
		% Range % Gain % Offset % Precision;
	};
};

// Speed/ Sensitivity enumerations
enum eSpeed	{Zero=0, Low, Mid, High};

struct T_Settings {
// for system settings screen
	T_RGOP	ExciterVoltage,		// settings for each type of parameter
			ExciterCurrent,
			OutputVoltage,
			OutputCurrent,
			InputVoltage,
			InputCurrent,
			RegulatorVoltage,
			RegulatorCurrent;
	Value	ProtectFactor,
			ProtectMaxVout,
			ProtectMaxIout,
			ProtectMaxIin,
			RegV0, RegVmax,		// values for regulator 0 and 100%
			GapV0, GapVmax;		//  	  and gap 0 & 100%
	int 	ArcSensitivity;
	
	// Other settings
	int iHV_Mins, 	iHV_Secs,
		iHV_Output, iHV_Protect,
		iRegRange, 	iRegSpeed,
		iResGap,  	iResSpeed;
/*	int	biAlarmSound:1,		// alarm sound on/off
		biAlarmLight:1;		// alarm light on/off
*/	
	// default values for the settings
	T_Settings()
	{
		ExciterVoltage.Range = 6000;
		ExciterCurrent.Range = 2000;
		OutputVoltage.Range  = 400;
		OutputCurrent.Range  = 1000;
		InputVoltage.Range   = 430;
		InputCurrent.Range   = 500;
		RegulatorVoltage.Range = 1000;
		RegulatorCurrent.Range = 1000;
		ProtectFactor  = 1200;
		ProtectMaxVout	= 1000;
		ProtectMaxIout	= 1000;
		ProtectMaxIin	= 1000;
		RegV0 = 0;	RegVmax = 100;
		GapV0 = 0;	GapVmax = 100;
		
		iHV_Mins = 1;	iHV_Secs = 0;
	};
	
	// serialization function
	void	Serialize(Stream& stream)
	{
		stream 
		% ExciterVoltage	% ExciterCurrent
		% OutputVoltage		% OutputCurrent
		% InputVoltage		% InputCurrent
		% RegulatorVoltage	% RegulatorCurrent
		% ProtectFactor		% ProtectMaxVout
		% ProtectMaxIout	% ProtectMaxIin
		% RegV0				% RegVmax
		% GapV0				% GapVmax
		% ArcSensitivity
		// Other settings
		% iHV_Mins	% iHV_Secs
		% iHV_Output % iHV_Protect
		% iRegRange % iRegSpeed
		% iResGap % iResSpeed
/*		("biAlarmSound",	biAlarmSound)
		("biAlarmLight",	biAlarmLight)
*/
		;
	};
};

T_Settings	Settings;


#endif
