#include "main.h"
#include "NIDAQmx.h"


/**********************************************************************/
#define DAQmxErrChk(functionCall) if( DAQmxFailed(error=(functionCall)) ) goto Error; else
void	NiCheck()
{
   int32      	error=0;
   TaskHandle   taskHandle=0;
   uInt32      	data;
   char      	errBuff[2048]={'\0'};
   int32      	read;

   /*********************************************/
   // DAQmx Configure Code
   /*********************************************/
   DAQmxErrChk (DAQmxCreateTask("",&taskHandle));
   DAQmxErrChk (DAQmxCreateDIChan(taskHandle,"Dev1/port0","",DAQmx_Val_ChanForAllLines));

   /*********************************************/
   // DAQmx Start Code
   /*********************************************/
   DAQmxErrChk (DAQmxStartTask(taskHandle));

   /*********************************************/
   // DAQmx Read Code
   /*********************************************/
   DAQmxErrChk (DAQmxReadDigitalU32(taskHandle,1,10.0,DAQmx_Val_GroupByChannel,&data,1,&read,NULL));

	//	text = "Data acquired: " + AsString(data);
   
Error:
   if( DAQmxFailed(error) )
      DAQmxGetExtendedErrorInfo(errBuff,2048);
   if( taskHandle!=0 ) {
      /*********************************************/
      // DAQmx Stop Code
      /*********************************************/
      DAQmxStopTask(taskHandle);
      DAQmxClearTask(taskHandle);
   }
//   if( DAQmxFailed(error) )      text.SetText(Format("DAQmx Error: %s\n",errBuff));
}


GUI_APP_MAIN
{
 	if(FileExists("Data.Txt") && !LoadFromFile(Settings, "Data.txt"))
        Exclamation("Error loading configuration file!");

	JFControlsDemo().Run();

	StoreToFile(Settings,"Data.txt");
}

JFControlsDemo::JFControlsDemo()
{
	CtrlLayout(*this);
	Title("JFControls - Demo package");							// window title
	MinimizeBox();												// I want the min box
	
	sliCont1 <<= THISBACK(Upd_sliInd1);
	sliCont2 <<= THISBACK(Upd_sliInd2);
	
	sliswCont1.WhenSlideFinish = THISBACK(Upd_sliswInd1);
	sliswCont2.WhenSlideFinish = THISBACK(Upd_sliswInd2);
	
	sliswCont1.SetData(3,"Zero");
	sliswCont1.SetData(2,"Low");
	sliswCont1.SetData(1,"Mid");
//	sliswCont1.SetData(0,"High");
}


void	JFControlsDemo::Upd_sliInd1()
{
	sliInd1 <<= ~sliCont1;
//	::NiCheck();
	// text.SetText("Value is : " + HexString(~sliCont1));
}

void	JFControlsDemo::Upd_sliInd2()
{
	sliInd2 <<= ~sliCont2;
}

void	JFControlsDemo::Upd_sliswInd1()
{
	sliswInd1.SetPos(sliswCont1.GetPos());
}

void	JFControlsDemo::Upd_sliswInd2()
{
	sliswInd2.SetPos(sliswCont2.GetPos());
}

