#include "nidaqmx.h"
//#include "core/core.h"

/**********************************************************************/
#define DAQmxErrChk(functionCall) if( DAQmxFailed(error=(functionCall)) ) goto Error; else

void	MyTest()
{
	return;
}

int32	Ni_ReadDI(int8 Dev, int8 Port, int32 *DI)
{
   int32     	error=0;
   TaskHandle   taskHandle=0;
   uInt32    	data;
   char      	errBuff[2048]={'\0'};
   int32     	read;

   //*********************************************
   // DAQmx Configure Code
   //*********************************************
   DAQmxErrChk (DAQmxCreateTask("",&taskHandle));
   DAQmxErrChk (DAQmxCreateDIChan(taskHandle, 
   				(const char *)(Format("Dev%c/port%c",Dev,Port)),
   				"",DAQmx_Val_ChanForAllLines));

   //*********************************************
   // DAQmx Start Code
   //*********************************************
   DAQmxErrChk (DAQmxStartTask(taskHandle));

   //********************************************
   // DAQmx Read Code
   //********************************************
   DAQmxErrChk (DAQmxReadDigitalU32(taskHandle,1,10.0,DAQmx_Val_GroupByChannel,&data,1,&read,NULL));

	// assign the read inputs to *DI
	*DI = data;
	return 0;

Error:
   if( DAQmxFailed(error) )
      DAQmxGetExtendedErrorInfo(errBuff,2048);
   if( taskHandle!=0 ) {
      //*********************************************
      // DAQmx Stop Code
      //*********************************************
      DAQmxStopTask(taskHandle);
      DAQmxClearTask(taskHandle);
   }
   if( DAQmxFailed(error) )      return error;
}
