#ifndef _OgreTest_OgreCtrl_h_
#define _OgreTest_OgreCtrl_h_

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#include <Ogre.h>

void SetLocalFileRoot(const char *root);
String LocalFile(String file);

NTL_MOVEABLE(Ogre::Vector2);
NTL_MOVEABLE(Ogre::Vector3);
typedef Ogre::Vector2 Point2f;
typedef Ogre::Vector3 Point3f;

// Upp compatible OGRE types
struct VertexPNT : public Moveable<VertexPNT>
{
	Ogre::Vector3 position;
	Ogre::Vector3 normal;
	Ogre::Vector2 texcoord0;
};

#include "Types.h"
#include "PerlinNoise.h"

#define DEGRAD_CONVERT (3.14159265358979323846f/360.0f)
#define DEG2RAD(x) (x * DEGRAD_CONVERT)

class OgreCtrl : public DHCtrl
{	
public:
	String 	GetError() const 	{ return error; }
	bool	IsError() const		{ return !error.IsEmpty(); }

	bool 	HasRenderSystem()	{ return Root().getRenderSystem() != NULL; }
	bool 	HasRenderWindow()	{ return renderwindow != NULL; }
	
	bool 	CanRender()			{ return !IsError() && HasRenderSystem() && HasRenderWindow(); }
	
	Ogre::Root &			Root() 				{ return Single<Ogre::Root>(); }	
	Ogre::MeshManager &		MeshManager()		{ return Ogre::MeshManager::getSingleton(); }
	Ogre::TextureManager &	TextureManager()	{ return Ogre::TextureManager::getSingleton(); }
	Ogre::HardwareBufferManager & BufferManager() { return Ogre::HardwareBufferManager::getSingleton(); }
protected:
	virtual void OgreOpen();
	virtual void OgreClose();
	virtual void OgreResize();
	
	void SetError(const String &err)		{ error = err; }
	void ClearError()						{ error.Clear(); }
	
	void Direct3D9RenderSystem()			{ SetRenderSystem("Direct3D9 Rendering Subsystem"); }
	void Direct3D8RenderSystem()			{ SetRenderSystem("Direct3D8 Rendering Subsystem"); }
	void OpenGLRenderSystem()				{ SetRenderSystem("OpenGL Rendering Subsystem"); }
	
	void SetRenderSystem(const char *systemname);
	
	Ogre::RenderSystem &GetRenderSystem()	{ return *Root().getRenderSystem(); }
	Ogre::RenderWindow &GetRenderWindow()	{ return *renderwindow; }
	Ogre::Camera	 &	Camera()			{ return *camera; };
	Ogre::SceneManager &GetScene()			{ return *scene; }
	
	virtual Ogre::SceneManager *	CreateSceneManager();
	virtual Ogre::Camera *			CreateCamera(String name, float nearplane = 1.0f, float farplane = 1000.0f);
	Ogre::TexturePtr				GetTexture(const char *name, const char *group);
		
	bool 				IsKey(KeyInfo &info, dword key) 	{ return key == info.key[0] || key == info.key[1]; }
	
	OgreCtrl();
	virtual void Close() { OgreClose(); Ctrl::Close(); }
private:
	String error;
	Ogre::RenderWindow *	renderwindow;
	Ogre::Camera *			camera;
	Ogre::SceneManager *	scene;
	
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);	
	
	virtual void Layout();
	virtual void State(int reason);
};

#endif
