#include "OgreCtrl.h"

#ifdef _DEBUG
#define OGRECHK ASSERT(CanRender());
#define OGRECHK1(x) ASSERT(CanRender());
#else
#define OGRECHK if (!CanRender()) return;
#define OGRECHK1(x) if (!CanRender()) return x;
#endif

void OgreCtrl::OgreOpen()
{
	ClearError();
	if (IsError()) return;
	GetRenderSystem().setConfigOption("Video Mode","800 x 600 @ 16-bit colour");
	
	Root().initialise(false,"Some Window Title");
	Ogre::NameValuePairList misc;
	misc["externalWindowHandle"] = Ogre::StringConverter::toString( (size_t)DHCtrl::GetHWND());
	renderwindow = Root().createRenderWindow("Ogre3D RenderWindow", 800, 600, false, &misc );

	Ogre::ResourceGroupManager::getSingleton().initialiseAllResourceGroups();
	CreateSceneManager();	
	camera = CreateCamera("Default Camera");
	
	if (!CanRender())
		SetError("Initialisation failed");
}

void OgreCtrl::OgreClose()
{
	if (HasRenderWindow())
		Root().detachRenderTarget(&GetRenderWindow());
}

void OgreCtrl::OgreResize()
{
	if (!IsOpen()) return;
	OGRECHK;
	Rect rect = GetScreenRect(); 

	// notify "render window" instance 
	GetRenderWindow().windowMovedOrResized(); 

	// Adjust camera's aspect ratio, too 
	if ((rect.bottom - rect.top) != 0)
		Camera().setAspectRatio((Ogre::Real)GetRenderWindow().getWidth() / (Ogre::Real)GetRenderWindow().getHeight()); 
	Root().renderOneFrame();
}

void OgreCtrl::Layout()
{
	OgreResize();
}

void OgreCtrl::State(int reason)
{
	if (reason == Ctrl::CLOSE) {
		OgreClose();
	}
	DHCtrl::State(reason);
	if (reason == Ctrl::OPEN) {
		OgreOpen();
		Layout();
	}	
}

void OgreCtrl::SetRenderSystem(const char *systemname)
{
	Ogre::String s = systemname;
	Ogre::RenderSystem *rs = Root().getRenderSystemByName(s);

	Ogre::RenderSystemList *list = Root().getAvailableRenderers();
	int c=0;
	while(c < (int) list->size())
	{
		String rname = list->at(c)->getName();
		c++; // <-- oh how clever
	}

	if (rs) {
		Root().setRenderSystem(rs);
		GetRenderSystem().setConfigOption("Full Screen","No");  
	}
	else
		SetError(Format("Unable to set rendering system : %s", systemname));
}

Ogre::SceneManager * OgreCtrl::CreateSceneManager()
{
	scene = Root().createSceneManager(Ogre::ST_GENERIC, "Scene Manager");
	scene->setAmbientLight(Ogre::ColourValue(0.5, 0.5, 0.5));		
	return scene;
}

Ogre::Camera * OgreCtrl::CreateCamera(String name, float nearplane, float farplane)
{
	Ogre::Camera *camera = scene->createCamera(name);
	// Position it at 500 in Z direction
	camera->setPosition(Ogre::Vector3(0,0,500));
	// Look back along -Z
	camera->lookAt(Ogre::Vector3(0,0,-300));
	camera->setNearClipDistance(nearplane);
	camera->setFarClipDistance(farplane);
	// Set the viewport
	Ogre::Viewport *viewport = GetRenderWindow().addViewport(camera);
	viewport->setBackgroundColour(Ogre::ColourValue(0.7f, 0.7f, 0.7f, 1.0f)); 	
	
	return camera;
}

Ogre::TexturePtr OgreCtrl::GetTexture(const char *name, const char *group)
{
	return TextureManager().load(name, group);
}

LRESULT OgreCtrl::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	if (message == WM_PAINT) {
		if (CanRender())
			Root().renderOneFrame();
		PAINTSTRUCT ps;		
		BeginPaint(GetHWND(), &ps);
		EndPaint(GetHWND(), &ps);		
		return 0;
	}
	return DHCtrl::WindowProc(message, wParam, lParam);
}

OgreCtrl::OgreCtrl()
{
	renderwindow = NULL;
	camera = NULL;
	scene = NULL;
	SetError("Not initialised");
}

#ifdef _DEBUG
String localroot;
void SetLocalFileRoot(const char *root) { localroot = root; }
String LocalFile(String file) { return AppendFileName(localroot, file); }
#define MULTIMAT_STAT
#define DRAW_AXIS
#else
void SetLocalFileRoot(const char *root) { }
String LocalFile(String file) { return GetExeDirFile(file); }
#endif