#include "UppGL.h"

class QuickSineCls {
	float cache[ANGLE_CACHE_SIZE+1];
public:
	QuickSineCls() {
		double inc = TWOPI / (ANGLE_CACHE_SIZE+1);
		for (int i = 0; i <= ANGLE_CACHE_SIZE; i++)
			cache[i] = (float)sin(inc*i);
	}
	float operator()(int i) { return cache[i & ANGLE_CACHE_SIZE]; }
};
class QuickCosineCls {
	float cache[ANGLE_CACHE_SIZE+1];
public:
	QuickCosineCls() {
		double inc = TWOPI / (ANGLE_CACHE_SIZE+1);
		for (int i = 0; i <= ANGLE_CACHE_SIZE; i++)
			cache[i] = (float)cos(inc*i);
	}
	float operator()(int i) { return cache[i & ANGLE_CACHE_SIZE]; }
};
float QuickSin(int i)	{ return Single<QuickSineCls>()(i); }
float QuickCos(int i)	{ return Single<QuickCosineCls>()(i); }
float QuickAngleToRad(int i) { return (float)((i & ANGLE_CACHE_SIZE) * (TWOPI / (ANGLE_CACHE_SIZE + 1))); }
float QuickAngleToDeg(int i) { return (float)((i & ANGLE_CACHE_SIZE) * (360.0 / (ANGLE_CACHE_SIZE + 1))); }