#include "FPSCamera.h"

#define KEYNAMESPACE CameraKeys
#define KEYGROUPNAME CAMERA_KEYGROUP		
#define KEYFILE      <UppGL/FPSCamera/FPSCamera.key>	
#include <CtrlLib/key_source.h>

#define SMOOTHNESS 20

bool FPSCamera::Key(dword key, int count)
{
	float move_shift = (key & K_SHIFT) ? shiftmult : 1.0f;
	int noshift = key & ~K_SHIFT;
	float cnt = (float)count;
	if (isomove) {
		// Forward/Back
		if (IsKey(CameraKeys::AK_FORWARD(), noshift))
			Move(glm::cross(Right(), Z_AXIS)*-cnt * keysensitivity * move_shift);
		else if (IsKey(CameraKeys::AK_BACK(), noshift))
			Move(glm::cross(Right(), Z_AXIS)*cnt * keysensitivity * move_shift);
		// Left/Right
		else if (IsKey(CameraKeys::AK_LEFT(), noshift))
			Move(Right()*-cnt * keysensitivity * move_shift);
		else if (IsKey(CameraKeys::AK_RIGHT(), noshift))
			Move(Right()*cnt * keysensitivity * move_shift);
		// Up/Down
		else if (IsKey(CameraKeys::AK_UP(), noshift))
			Move(Z_AXIS*cnt * (keysensitivity * move_shift));
		else if (IsKey(CameraKeys::AK_DOWN(), noshift))
			Move(Z_AXIS*-cnt * keysensitivity * move_shift);
		else 
			return false;			
	}
	else {
		// Forward/Back
		float d = cnt * keysensitivity * move_shift / SMOOTHNESS;
		Vec3f p = Position();
		if (IsKey(CameraKeys::AK_FORWARD(), noshift)) {
			d = -d;
			for (int i = 0; i < SMOOTHNESS; i++) {
				MoveForward(d);
				WhenMove();
			}
		}
		else if (IsKey(CameraKeys::AK_BACK(), noshift)) {
			for (int i = 0; i < SMOOTHNESS; i++) {
				MoveForward(d);
				WhenMove();
			}
		}
		// Left/Right
		else if (IsKey(CameraKeys::AK_LEFT(), noshift)) {
			d = -d;
			for (int i = 0; i < SMOOTHNESS; i++) {
				MoveRight(d);
				WhenMove();
			}
		}
		else if (IsKey(CameraKeys::AK_RIGHT(), noshift)) {
			for (int i = 0; i < SMOOTHNESS; i++) {
				MoveRight(d);
				WhenMove();
			}
		}
		// Up/Down
		else if (IsKey(CameraKeys::AK_UP(), noshift)) {
			for (int i = 0; i < SMOOTHNESS; i++) {
				MoveUp(d);
				WhenMove();
			}
		}
		else if (IsKey(CameraKeys::AK_DOWN(), noshift)) {
			d = -d;
			for (int i = 0; i < SMOOTHNESS; i++) {
				MoveUp(d);
				WhenMove();
			}
		}
		else if (IsKey(CameraKeys::AK_ROLL_RIGHT(), noshift))
			Roll(-cnt * keysensitivity);
		else if (IsKey(CameraKeys::AK_ROLL_LEFT(), noshift))
			Roll(cnt * keysensitivity);		
		else 
			return false;
	}
	return true;
}

bool FPSCamera::MouseDrag(Point drag, dword keyflags)
{
	float x = (float)drag.x;
	float y = (float)drag.y;
	Rotate(dragsensitivity*x, fpsup);
	//Yaw(dragsensitivity*x);
	if (!locky)
		Pitch(dragsensitivity*(inverty ? -y : y));
	return true;
}

bool FPSCamera::MouseWheel(Point p, int zdelta, dword keyflags)
{
	float move_shift = (keyflags & K_SHIFT) ? shiftmult : 1.0f;
	MoveUp(zdelta * (wheelsensitivity * move_shift));	
	return false;
}
