void EnableClientStatePNT();
void DisableClientStatePNT();

#define MESH_BUFFER_OFFSET(i) (GLvoid *)(&((Vertex *)NULL)->i)

struct SubMesh : public Moveable<SubMesh>
{
	SubMesh()	 		{}
	SubMesh(const SubMesh &s)	 	{ material = s.material; byteoffset = s.byteoffset, count = s.count; }
	
	GLMaterial	material;
	int			byteoffset;
	int			count;
	
	SubMesh &operator=(const SubMesh &s) { material = s.material; byteoffset = s.byteoffset, count = s.count; return *this; }
	
	int		Index() const			{ return byteoffset >> 2; }
	void 	Serialize(Stream &s) 	{ s % byteoffset % count; } 
};

struct MeshBuffer
{
	MeshBuffer() : vbo(0), ibo(0), tbo(0) 	{ }
	~MeshBuffer() 							{ Clear(); }
	
	GLuint				vbo;	// Vertex attribs
	GLuint				ibo;	// Indices
	GLuint				tbo;	// Tangents for bump mapping
	
	void 		Activate() const;
	static void Deactivate();
	
	bool		HasTangents() const 	{ return tbo; }	
	
	void Render(const Vector<SubMesh> &sub) const						{ if (!sub.GetCount()) return; Render(&sub[0], &sub.Top()); }
	void RenderNoMat(const Vector<SubMesh> &sub) const					{ if (!sub.GetCount()) return; RenderNoMat(&sub[0], &sub.Top());}
	void Render(const SubMesh *begin, const SubMesh *end) const			{ Activate(); QRender(begin, end); /*Deactivate();*/ }
	void RenderNoMat(const SubMesh *begin, const SubMesh *end) const	{ Activate(); QRenderNoMat(begin, end); /*Deactivate();*/ }
	
	void QRender(const Vector<SubMesh> &sub) const		{ if (!sub.GetCount()) return; QRender(&sub[0], &sub.Top()); }
	void QRenderNoMat(const Vector<SubMesh> &sub) const	{ if (!sub.GetCount()) return; QRenderNoMat(&sub[0], &sub.Top());}	
	void QRender(const SubMesh *begin, const SubMesh *end) const;
	void QRenderNoMat(const SubMesh *begin, const SubMesh *end) const;
	
	void Clear();
};

struct MeshData : public ManagedResourceData {
	MeshBuffer			buffer;
	Vector<Vertex> 		vertex;
	Vector<GLuint>		index;
	Vector3f			tangents;
	Box					bounds;
	Vector<SubMesh> 	submesh;

	virtual void Free()	{ buffer.Clear(); }

	void		CreateNormals(bool intialise = true);
	void		CreateTangents();
	void 		RemoveUselessTriangles();
	void		CalcBounds();
	void		ReverseWinding();
	void		Scale(float x, float y, float z);
	void		TextureOffset(float u, float v);
	void		TextureScale(float u, float v);
	
	void 		Copy(MeshData &m)		{ m.buffer.Clear(); m.vertex <<= vertex; m.index <<= index; m.submesh <<= submesh; m.bounds = bounds; }

	bool 		HasBuffer() const		{ return buffer.vbo && buffer.ibo; }
	bool 		HasMirror() const 		{ return vertex.GetCount() && index.GetCount(); }
	bool		HasTangents() const 	{ return tangents.GetCount() || buffer.HasTangents(); }
	void 		Serialize(Stream &s);

	int 		TriangleCount() const;
	
	void 		Clear();
};

struct Mesh : public ManagedResource<MeshData> {
	Vector<SubMesh> 		submesh;	

	bool 					Load(const String &name, bool cache, bool mirror);
	void					SetCustom(MeshData &mesh)	{ Set(&mesh); submesh <<= Get()->submesh; }

	bool					SaveBIN(String file);

	const MeshBuffer &		Buffer() const		{ Chk(); return Get()->buffer; }
	const Vector<Vertex> &	VData() const		{ Chk(); return Get()->vertex; }
	const Vector<GLuint> &	IData() const		{ Chk(); return Get()->index; }
	const Box &				Bounds() const		{ Chk(); return Get()->bounds; }
	bool 					HasBuffer() const	{ Chk(); return Get()->HasBuffer(); }
	bool 					HasMirror() const 	{ Chk(); return Get()->HasMirror(); }
	void 					CopyTo(MeshData &m) { Chk(); Get()->Copy(m); }
	bool					Cache(bool force = false);
	void					UnCache() const		{ Chk(); Get()->buffer.Clear(); }
	void					UnMirror() const	{ Chk(); Get()->vertex.Clear(); Get()->index.Clear(); }

	void Render() const							{ Chk(); Get()->buffer.Render(submesh); }
	void RenderNoMat() const					{ Chk(); Get()->buffer.RenderNoMat(submesh); }
	void Render(int ix) const					{ Chk(); Get()->buffer.Render(&submesh[ix], &submesh[ix]); }
	void Render(int first, int last) const		{ Chk(); Get()->buffer.Render(&submesh[first], &submesh[last]); }
	
	void QRender() const						{ Chk(); Get()->buffer.QRender(submesh); }
	void QRenderNoMat() const					{ Chk(); Get()->buffer.QRenderNoMat(submesh); }
	void QRender(int ix) const					{ Chk(); Get()->buffer.QRender(&submesh[ix], &submesh[ix]); }
	void QRender(int first, int last) const		{ Chk(); Get()->buffer.QRender(&submesh[first], &submesh[last]); }
					
	void Serialize(Stream &s)					{ s % submesh; }	
	
	Mesh &operator=(Mesh &m)					{ submesh <<= m.submesh; Set(m.Get()); return *this; }
	bool operator==(const Mesh &m)				{ return Get() == m.Get(); }	
	bool operator==(const MeshData &m)			{ return Get() == &m; }	
private:
	bool			LoadMesh(const String &file);
	bool			LoadOBJ(String file);
	bool			LoadBIN(String file);
};

Vector3f 	  CalculateTriangleTangents(const Vector<Vertex> &vertex, const Vector<GLuint> &index);
Vector3f 	  CalculateTriangleTangents(const Vector<Vertex> &vertex, const Vector<Triangle32> &index);
Vec3f 		  CalculateTriangleTangent(const Vertex &v1, const Vertex &v2, const Vertex &v3);
                                                                                