#include "UppGL.h"
       
void PackingTree::Create(const Size &sz)
{
	Clear();
	root.rect = sz;
}
 
Rect PackingTree::Add(const Size &sz)
{
	ASSERT(IsInit());
	Node *n = Add(&root, sz);
	return n ? n->rect : Null;
}

void PackingTree::Remove(const Rect &r)
{
	ASSERT(IsInit());
	bool result = Remove(&root, r);
}

void PackingTree::Clear()
{
	if (root.child[0])
		Destroy(root.child[0]);
	if (root.child[1])
		Destroy(root.child[1]);
	root.child[0] = NULL;
	root.child[1] = NULL;
	root.used = false;
}

void PackingTree::Destroy(Node *n)
{
	if (n->child[0])
		Destroy(n->child[0]);
	if (n->child[1])
		Destroy(n->child[1]);
	n->child[0] = n->child[1] = NULL;
	delete n;
}

int PackingTree::Remove(Node *n, const Rect &r)
{
	if (n->IsLeaf() && n->used) {
		if (n->rect == r)
			n->used = false;
		return !n->used;
	}
	else {
		if (n->child[0] && Remove(n->child[0], r)) return Merge(n, n->child[0], n->child[1]);
		if (n->child[1] && Remove(n->child[1], r)) return Merge(n, n->child[1], n->child[0]);
		return n->IsLeaf();
	}
}

bool PackingTree::Merge(Node *n, Node *a, Node *b) {
	if (b->IsLeaf() && !b->used) {
		// Complete merge
		delete n->child[0];
		delete n->child[1];
		n->child[0] = n->child[1] = NULL;	
		return true;
	}
	else {
		a->used = false;	
		return false;
	}
}

PackingTree::Node *PackingTree::Add(Node *n, const Size &sz)
{
	if (!n->IsLeaf()) {
		Node *newnode = Add(n->child[0], sz);
		return newnode ? newnode : Add(n->child[1], sz);
	}
	else {
		Size nsz = n->rect.GetSize();
		// If there is already an image or the space is too small
		if (n->used || sz.cx > nsz.cx || sz.cy > nsz.cy) return NULL;
		// If the space fits perfectly
		if (sz == nsz) {
			n->used = true;
			return n;
		}	
		// Otherwise split node
		n->child[0] = new Node;	
		n->child[1] = new Node;	
		
		if (nsz.cx - sz.cx > nsz.cy - sz.cy) {
			// Horizontal split
			n->child[0]->rect = RectC(n->rect.left, n->rect.top, sz.cx, nsz.cy);
			n->child[1]->rect = n->child[0]->rect;
			n->child[1]->rect.left = n->child[1]->rect.right+1;
			n->child[1]->rect.right = n->rect.right;
		}
		else {
			// Vertical split
			n->child[0]->rect = RectC(n->rect.left, n->rect.top, nsz.cx, sz.cy);
			n->child[1]->rect = n->child[0]->rect;
			n->child[1]->rect.top = n->child[1]->rect.bottom+1;
			n->child[1]->rect.bottom = n->rect.bottom;			
		}
		return Add(n->child[0], sz);
	}
	return NULL;
}