class PackingTree
{
public:
	struct Node {
		Node() : rect(Null), used(false) 	{ child[0] = child[1] = NULL; }
		~Node()								{ delete child[0]; delete child[1]; }
		
		bool IsLeaf() const 				{ return child[0] == NULL && child[1] == NULL; }
		
		Rect rect;
		Node *child[2];
		bool used;
	};

	Node root;
public:
	PackingTree() 	{}
	~PackingTree() 	{ Clear(); }
	
	void 	Create(const Size &sz);
	Rect 	Add(const Size &sz);
	void	Remove(const Rect &r);
	void 	Clear();
	
	bool	IsInit() const		{ return !root.rect.IsNullInstance(); }
private:
	Node *	Add(Node *n, const Size &sz);
	int		Remove(Node *n, const Rect &r);
	bool	Merge(Node *n, Node *a, Node *b);
	void	Destroy(Node *n);
};

