class RenderTexture;

class FrameBuffer : public Pte<FrameBuffer>
{
private:
	GLuint fbo;
	GLuint rbo;
	Size sz;
	bool colorattached;
	bool depthattached;
public:
	FrameBuffer() : fbo(0), rbo(0), sz(Null), colorattached(false), depthattached(false) {}
	virtual ~FrameBuffer() { Clear(); }
	
	bool Create(Size sz, bool depth_buffer = true);
	bool Activate() const;
	void Deactivate() const;

	bool SetColorTexture(const RenderTexture &t);	
	bool SetDepthTexture(const RenderTexture &t);	
	bool DetachColor();
	bool DetachDepth();
	
	bool CreateDepthRBO();
	void DestroyDepthRBO();
	bool AttachDepthRBO();
	bool DetachDepthRBO(); 
	
	bool IsComplete() const;

	bool HasColor()					{ return colorattached; }
	bool HasDepth()					{ return depthattached; }

	void Clear();
	bool IsNullInstance() const		{ return fbo == 0; }
	const Size &GetSize() const		{ return sz; }	
};	

class RenderTexture : public ManagedResource<TextureData>
{
private:
	Ptr<FrameBuffer> fbo;
	int 			 type;
	bool 			 mipmaps;
public:
	enum {
		NULL_TYPE,
		DEPTH_8,
		DEPTH_16,
		DEPTH_24,
		DEPTH_32,
		COLOR_32,
		TYPE_COUNT
	};

	RenderTexture() : type(NULL_TYPE), mipmaps(false)	{}
	
	void		ActivateAlways(int unit = 0) const 	{ Get()->ActivateAlways(unit); }
	void 		Activate(int unit = 0) const		{ Get()->Activate(unit); }
	
	bool Create(const String &name, FrameBuffer &_fbo, int type = COLOR_32);
	bool StartRender(bool clear)					{ return StartRender(fbo->GetSize(), clear); }
	bool StartRender(const Rect &r, bool clear);
	void EndRender();
	
	void GenerateMipMaps();
	
	GLuint		Id() const				{ Chk(); return Get()->id; }
	const Size &GetSize()				{ return fbo->GetSize(); } 
};
