#include "RotCamera.h"

#define KEYNAMESPACE CameraKeys
#define KEYGROUPNAME CAMERA_KEYGROUP		
#define KEYFILE      <UppGL/RotCamera/RotCamera.key>		
#include <CtrlLib/key_source.h>

void RotCamera::SetView()
{
	glMatrixMode(GL_MODELVIEW);
	glTranslatef(position.x, position.y, position.z);
	glMultMatrixf(~transform);
}

bool RotCamera::Key(dword key, int count)
{
	float move_shift = (key & K_SHIFT) ? 5.0f : 1.0f;
	int noshift = key & ~K_SHIFT;
	float cnt = (float)count;
	// Forward/Back
	if (IsKey(CameraKeys::AK_FORWARD(), noshift))
		MoveForward(cnt * keysensitivity * move_shift);
	else if (IsKey(CameraKeys::AK_BACK(), noshift))
		MoveForward(-cnt * keysensitivity * move_shift);
	// Up/Down
	else if (IsKey(CameraKeys::AK_UP(), noshift))
		MoveUp(-cnt * (keysensitivity * move_shift));
	else if (IsKey(CameraKeys::AK_DOWN(), noshift))
		MoveUp(cnt * keysensitivity * move_shift);	
	else 
		return false;
	return true;
}

bool RotCamera::MouseDrag(Point drag, dword keyflags)
{
	rot.y += dragsensitivity*((float)drag.x);
	rot.x += dragsensitivity*((float)drag.y);
	UpdateTransform();
	return true;
}

bool RotCamera::MouseWheel(Point p, int zdelta, dword keyflags)
{
	MoveGlobal(0.0f, 0.0f, 1.0f, ((float)zdelta) * wheelsensitivity);
	return true;
}


