#include "UppGL.h"

SkyDome::SkyDome()
{
	skymap = 0;
	indexcnt = 0;
	init = false;
}

void SkyDome::Render(float sunangle)
{
	ASSERT(init);
	if (!init) return;
	float translatex = sunangle / 360.0f;
	glDisable(GL_DEPTH_TEST);
	// Texture
	glEnable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glBindTexture(GL_TEXTURE_2D, skymap);
	// Translate texture according to time of day
	glMatrixMode(GL_TEXTURE);
	glPushMatrix();
	glTranslatef(translatex, 0.0f, 0.0f);
	// Vertex buffer
	glEnableClientState(GL_VERTEX_ARRAY);
	glBindBufferARB(GL_ARRAY_BUFFER_ARB, vertexvbo);
	glVertexPointer(3, GL_FLOAT, 0, NULL);
	// Normal buffer
	glEnableClientState(GL_NORMAL_ARRAY);
	glBindBufferARB(GL_ARRAY_BUFFER_ARB, normalvbo);
	glNormalPointer(GL_FLOAT, 0, NULL);
	// Texture buffer
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glBindBufferARB(GL_ARRAY_BUFFER_ARB, texturevbo);
	glTexCoordPointer(2, GL_FLOAT, 0, NULL);
	// Index buffer
	glEnableClientState(GL_INDEX_ARRAY);
	glBindBufferARB(GL_ELEMENT_ARRAY_BUFFER_ARB, indexvbo); // for indices
	glIndexPointer(GL_INT, 0, NULL);
	// Draw all triangles
	glDrawElements(GL_TRIANGLES, indexcnt, GL_UNSIGNED_INT, 0);
	// Disable VBOs
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_NORMAL_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);
	glDisableClientState(GL_INDEX_ARRAY);
	glBindBufferARB(GL_ARRAY_BUFFER_ARB, 0);
	glBindBufferARB(GL_ELEMENT_ARRAY_BUFFER_ARB, 0);
	// Finish
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glDisable(GL_TEXTURE_2D);	
	glEnable(GL_DEPTH_TEST);
}

void SkyDome::Init(GLuint map, float radius, int level)
{
	Vector<Vec2f> texcoord;
	Vector<Vec3f> normal;	

	ASSERT(map);
	skymap = map;
	Subdivider dome = DivideDemiSphere(radius, level);
	
	texcoord.SetCount(dome.Verticies().GetCount());
	normal.SetCount(dome.Verticies().GetCount());
	// Set texture coords
	for (int i = 0; i < texcoord.GetCount(); i++) {
		Vec2f &p = texcoord[i];
		p.x = 0;
		p.y = dome.Verticies()[i].z / radius;	
	}
	// Calculate normal
	for (int i = 0; i < dome.Triangle32s().GetCount(); i++) {
		Triangle32 &t = dome.Triangle32s()[i];
		Vec3f n = GetNormal(t, dome.Verticies());
		normal[t.a] += n;
		normal[t.b] += n;
		normal[t.c] += n;
	}
	for (int i = 0; i < normal.GetCount(); i++)
		normal[i] = glm::normalize(normal[i]);
	
	vertexvbo = CreateVBO(dome.Verticies());
	texturevbo = CreateVBO(texcoord);
	normalvbo = CreateVBO(normal);
	indexvbo = CreateVBO(dome.Triangle32s());
	
	indexcnt = dome.Triangle32s().GetCount() * 3;
	init = vertexvbo && texturevbo && normalvbo && indexvbo;
}

