class Subdivider : public Moveable<Subdivider> 
{
public:
	Subdivider(Vec3f *vdata, Vec2f *texdata, Triangle32 *idata, int vcnt, int icnt);
	Subdivider(float *vdata, float *texdata, int *idata, int vcnt, int icnt);
	
	void 				Divide(int level = 1);
	Vector<Vec3f> &	Verticies()			{ return vertex; }
	Vector<Triangle32> &Triangle32s()			{ return tri; }
	Vector<Vec2f> &	TexCoords()			{ return texture; }
	
	void ToMesh(MeshData &m);
private:
	Vector<Vec3f> 	vertex;
	Vector<Triangle32>	tri;
	Vector<Vec2f> 	texture;
	
	void 			Init(Vec3f *vdata, Vec2f *texdata, Triangle32 *tdata, int vcnt, int tcnt);
	void 			DoDivide();
	inline int		HalfPt(VectorMap<Point, int> &pt, int a, int b);
};

void		SetRadius(float radius, Subdivider &s);
Subdivider 	DivideSphere(float radius, int level);
Subdivider 	DivideDemiSphere(float radius, int level);
